% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGN.R
\name{GGN}
\alias{GGN}
\title{Construct Gene-Gene Network}
\usage{
GGN(
  Y,
  dirpath = tempdir(),
  count_device = 1,
  nComp = 5,
  rebuild_GGN = TRUE,
  save_file = TRUE,
  python_env = "scPOEM_env"
)
}
\arguments{
\item{Y}{The scRNA-seq data, sparse matrix.}

\item{dirpath}{The folder path to read or write file.}

\item{count_device}{The number of cpus used to train the Lasso model.}

\item{nComp}{The number of PCs used for regression}

\item{rebuild_GGN}{Logical. Whether to rebuild the gene-gene network (GGN) from scratch. If FALSE, the function will attempt to read from \code{GGN.mtx} under \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}

\item{python_env}{Name or path of the Python environment to be used.}
}
\value{
The GGN network.
}
\description{
Construct the gene-gene network via principle component regression.
}
\examples{
\donttest{
library(scPOEM)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
# Construct GGN net.
gg_net <- GGN(example_data_single$Y,
              file.path(dirpath, "single"),
              save_file=FALSE)
}

}
