% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_scMinimal.R
\name{subset_scMinimal}
\alias{subset_scMinimal}
\title{Subset an scMinimal object by specified genes, donors, cells, or cell types}
\usage{
subset_scMinimal(
  scMinimal,
  ctypes_use = NULL,
  cells_use = NULL,
  donors_use = NULL,
  genes_use = NULL,
  in_place = TRUE
)
}
\arguments{
\item{scMinimal}{environment A sub-container for the project typically
consisting of gene expression data in its raw and processed forms as well
as metadata}

\item{ctypes_use}{character The cell types to keep (default=NULL)}

\item{cells_use}{character Cell barcodes for the cells to keep (default=NULL)}

\item{donors_use}{character The donors to keep (default=NULL)}

\item{genes_use}{character The genes to keep (default=NULL)}

\item{in_place}{logical If set to TRUE then replaces the input object with the
new subsetted object (default=TRUE)}
}
\value{
A subsetted scMinimal object.
}
\description{
Subset an scMinimal object by specified genes, donors, cells, or cell types
}
\examples{
cell_names <- colnames(test_container$scMinimal_full$count_data)
cells_sub <- sample(cell_names,40)
scMinimal <- subset_scMinimal(test_container$scMinimal_full,
cells_use=cells_sub)
}
