% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition.matrix.R
\name{transition.matrix}
\alias{transition.matrix}
\title{Creates and Returns a Transition Probability Matrix for Deliberating Criminal Jury.}
\usage{
transition.matrix(jury_n)
}
\arguments{
\item{jury_n}{The number of jurors.}
}
\value{
A matrix of transition probabilities.
}
\description{
Returns a (jury_n + 1) by (jury_n + 1) matrix of probabilities.
Columns represent current state and rows represent next state. Column values sum to 1.
Depending on use, you may want to transpose rows and columns.
}
\examples{
   library(sate)

   transition.matrix(6)

   transition.matrix(jury_n=12)
}
