% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{df_rvec}
\alias{df_rvec}
\alias{pf_rvec}
\alias{qf_rvec}
\alias{rf_rvec}
\title{F Distribution, Using Multiple Draws}
\usage{
df_rvec(x, df1, df2, ncp = 0, log = FALSE)

pf_rvec(q, df1, df2, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qf_rvec(p, df1, df2, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rf_rvec(n, df1, df2, ncp = 0, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{df1, df2}{Degrees of freedom.
See \code{\link[=df]{df()}}. Can be rvecs.}

\item{ncp}{Non-centrality parameter.
Default is \code{0}. Cannot be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
F distribution, modified to work with
rvecs.
}
\details{
Functions \code{df_rvec()}, \code{pf_rvec()},
\code{pf_rvec()} and \code{rf_rvec()} work like
base R functions \code{\link[=df]{df()}}, \code{\link[=pf]{pf()}},
\code{\link[=qf]{qf()}}, and \code{\link[=rf]{rf()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rf_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{df_rvec()}, \code{pf_rvec()},
\code{pf_rvec()} and \code{rf_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3, 5.1),
               c(0.1, 2.3)))
df_rvec(x, df1 = 1, df2 = 3)
pf_rvec(x, df1 = 1, df2 = 3)

rf_rvec(n = 2, df1 = 1,df2 = 2:3, n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=df]{df()}}, \code{\link[=pf]{pf()}}, \code{\link[=qf]{qf()}}, \code{\link[=rf]{rf()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
