// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_lm_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 95> locations_array__ =
  {" (found before start of program)",
  " (in 'lm', line 74, column 2 to column 52)",
  " (in 'lm', line 75, column 2 to column 40)",
  " (in 'lm', line 76, column 2 to column 52)",
  " (in 'lm', line 77, column 2 to column 39)",
  " (in 'lm', line 80, column 2 to column 38)",
  " (in 'lm', line 81, column 2 to column 27)",
  " (in 'lm', line 82, column 2 to column 31)",
  " (in 'lm', line 126, column 2 to column 25)",
  " (in 'lm', line 127, column 2 to column 26)",
  " (in 'lm', line 85, column 4 to column 66)",
  " (in 'lm', line 90, column 6 to column 50)",
  " (in 'lm', line 88, column 6 to column 60)",
  " (in 'lm', line 87, column 4 to line 90, column 50)",
  " (in 'lm', line 91, column 4 to column 41)",
  " (in 'lm', line 99, column 8 to line 100, column 46)",
  " (in 'lm', line 96, column 8 to line 97, column 46)",
  " (in 'lm', line 95, column 11 to line 100, column 46)",
  " (in 'lm', line 94, column 8 to column 30)",
  " (in 'lm', line 93, column 6 to line 100, column 46)",
  " (in 'lm', line 92, column 28 to line 101, column 5)",
  " (in 'lm', line 92, column 4 to line 101, column 5)",
  " (in 'lm', line 83, column 19 to line 102, column 3)",
  " (in 'lm', line 83, column 2 to line 102, column 3)",
  " (in 'lm', line 129, column 4 to column 53)",
  " (in 'lm', line 130, column 4 to line 131, column 55)",
  " (in 'lm', line 132, column 4 to column 34)",
  " (in 'lm', line 128, column 19 to line 133, column 3)",
  " (in 'lm', line 128, column 2 to line 133, column 3)",
  " (in 'lm', line 108, column 6 to column 55)",
  " (in 'lm', line 109, column 6 to line 110, column 111)",
  " (in 'lm', line 106, column 21 to line 112, column 5)",
  " (in 'lm', line 106, column 4 to line 112, column 5)",
  " (in 'lm', line 105, column 2 to line 112, column 5)",
  " (in 'lm', line 114, column 4 to column 42)",
  " (in 'lm', line 113, column 2 to line 114, column 42)",
  " (in 'lm', line 119, column 12 to column 13)",
  " (in 'lm', line 119, column 6 to column 37)",
  " (in 'lm', line 120, column 6 to column 71)",
  " (in 'lm', line 118, column 9 to line 121, column 5)",
  " (in 'lm', line 117, column 6 to column 44)",
  " (in 'lm', line 116, column 4 to line 121, column 5)",
  " (in 'lm', line 115, column 23 to line 122, column 3)",
  " (in 'lm', line 115, column 2 to line 122, column 3)",
  " (in 'lm', line 43, column 2 to column 38)",
  " (in 'lm', line 44, column 2 to column 49)",
  " (in 'lm', line 45, column 2 to column 42)",
  " (in 'lm', line 46, column 2 to column 32)",
  " (in 'lm', line 47, column 2 to column 35)",
  " (in 'lm', line 48, column 2 to column 33)",
  " (in 'lm', line 49, column 2 to column 20)",
  " (in 'lm', line 50, column 2 to column 17)",
  " (in 'lm', line 52, column 8 to column 9)",
  " (in 'lm', line 52, column 2 to column 26)",
  " (in 'lm', line 53, column 2 to column 31)",
  " (in 'lm', line 54, column 8 to column 9)",
  " (in 'lm', line 54, column 18 to column 19)",
  " (in 'lm', line 54, column 2 to column 31)",
  " (in 'lm', line 55, column 8 to column 9)",
  " (in 'lm', line 55, column 2 to column 21)",
  " (in 'lm', line 56, column 2 to column 16)",
  " (in 'lm', line 57, column 8 to column 9)",
  " (in 'lm', line 57, column 2 to column 29)",
  " (in 'lm', line 58, column 8 to column 9)",
  " (in 'lm', line 58, column 18 to column 19)",
  " (in 'lm', line 58, column 2 to column 24)",
  " (in 'lm', line 59, column 8 to column 9)",
  " (in 'lm', line 59, column 2 to column 29)",
  " (in 'lm', line 60, column 8 to column 9)",
  " (in 'lm', line 60, column 18 to column 19)",
  " (in 'lm', line 60, column 21 to column 22)",
  " (in 'lm', line 60, column 2 to column 30)",
  " (in 'lm', line 63, column 2 to column 24)",
  " (in 'lm', line 64, column 8 to column 9)",
  " (in 'lm', line 64, column 2 to column 27)",
  " (in 'lm', line 65, column 8 to column 9)",
  " (in 'lm', line 65, column 2 to column 25)",
  " (in 'lm', line 67, column 4 to column 37)",
  " (in 'lm', line 68, column 4 to column 35)",
  " (in 'lm', line 66, column 19 to line 69, column 3)",
  " (in 'lm', line 66, column 2 to line 69, column 3)",
  " (in 'lm', line 74, column 8 to column 21)",
  " (in 'lm', line 74, column 35 to column 48)",
  " (in 'lm', line 75, column 8 to column 25)",
  " (in 'lm', line 76, column 8 to column 9)",
  " (in 'lm', line 77, column 9 to column 27)",
  " (in 'lm', line 80, column 8 to column 25)",
  " (in 'lm', line 81, column 8 to column 9)",
  " (in 'lm', line 81, column 18 to column 19)",
  " (in 'lm', line 82, column 8 to column 9)",
  " (in 'lm', line 126, column 8 to column 9)",
  " (in 'lm', line 127, column 8 to column 9)",
  " (in 'lm', line 127, column 18 to column 19)",
  " (in 'lm', line 36, column 4 to line 39, column 50)",
  " (in 'lm', line 35, column 52 to line 40, column 3)"};
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__, typename T4__, typename T5__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T1__>, T2__,
  T3__, T4__, stan::promote_args_t<T5__>>
mvn_ols_qr_lpdf(const T0__& theta_arg__, const T1__& b_arg__, const T2__&
                intercept, const T3__& ybar, const T4__& SSR, const T5__&
                sigma, const int& N, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__, typename T4__, typename T5__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T1__>, T2__,
  T3__, T4__, stan::promote_args_t<T5__>>
mvn_ols_qr_lpdf(const T0__& theta_arg__, const T1__& b_arg__, const T2__&
                intercept, const T3__& ybar, const T4__& SSR, const T5__&
                sigma, const int& N, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>, T2__, T3__, T4__,
                             stan::promote_args_t<T5__>>;
  int current_statement__ = 0;
  const auto& theta = stan::math::to_ref(theta_arg__);
  const auto& b = stan::math::to_ref(b_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 93;
    return (((-0.5 * ((stan::math::dot_self(stan::math::subtract(theta, b)) +
           (N * stan::math::square((intercept - ybar)))) + SSR)) /
           stan::math::square(sigma)) - (N * (stan::math::log(sigma) +
           0.91893853320467267)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_lm final : public model_base_crtp<model_lm> {
private:
  int has_intercept;
  int prior_dist_for_intercept;
  double prior_scale_for_intercept;
  double prior_mean_for_intercept;
  int prior_dist;
  int prior_PD;
  double eta;
  int J;
  std::vector<int> N;
  int K;
  std::vector<Eigen::Matrix<double,-1,1>> xbarR_inv;
  std::vector<double> ybar;
  double center_y;
  std::vector<double> s_Y;
  std::vector<Eigen::Matrix<double,-1,1>> Rb;
  std::vector<double> SSR;
  std::vector<Eigen::Matrix<double,-1,-1>> R_inv;
  double half_K;
  std::vector<double> sqrt_inv_N;
  std::vector<double> sqrt_Nm1;
  int u_1dim__;
  int u_2dim__;
  int z_alpha_1dim__;
  int log_omega_1dim__;
  int alpha_1dim__;
public:
  ~model_lm() {}
  model_lm(stan::io::var_context& context__, unsigned int random_seed__ = 0,
           std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ = "model_lm_namespace::model_lm";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 44;
      context__.validate_dims("data initialization", "has_intercept", "int",
        std::vector<size_t>{});
      has_intercept = std::numeric_limits<int>::min();
      current_statement__ = 44;
      has_intercept = context__.vals_i("has_intercept")[(1 - 1)];
      current_statement__ = 44;
      stan::math::check_greater_or_equal(function__, "has_intercept",
        has_intercept, 0);
      current_statement__ = 44;
      stan::math::check_less_or_equal(function__, "has_intercept",
        has_intercept, 1);
      current_statement__ = 45;
      context__.validate_dims("data initialization",
        "prior_dist_for_intercept", "int", std::vector<size_t>{});
      prior_dist_for_intercept = std::numeric_limits<int>::min();
      current_statement__ = 45;
      prior_dist_for_intercept = context__.vals_i("prior_dist_for_intercept")[(1
        - 1)];
      current_statement__ = 45;
      stan::math::check_greater_or_equal(function__,
        "prior_dist_for_intercept", prior_dist_for_intercept, 0);
      current_statement__ = 45;
      stan::math::check_less_or_equal(function__, "prior_dist_for_intercept",
        prior_dist_for_intercept, 1);
      current_statement__ = 46;
      context__.validate_dims("data initialization",
        "prior_scale_for_intercept", "double", std::vector<size_t>{});
      prior_scale_for_intercept = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 46;
      prior_scale_for_intercept = context__.vals_r("prior_scale_for_intercept")[(1
        - 1)];
      current_statement__ = 46;
      stan::math::check_greater_or_equal(function__,
        "prior_scale_for_intercept", prior_scale_for_intercept, 0);
      current_statement__ = 47;
      context__.validate_dims("data initialization",
        "prior_mean_for_intercept", "double", std::vector<size_t>{});
      prior_mean_for_intercept = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 47;
      prior_mean_for_intercept = context__.vals_r("prior_mean_for_intercept")[(1
        - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization", "prior_dist", "int",
        std::vector<size_t>{});
      prior_dist = std::numeric_limits<int>::min();
      current_statement__ = 48;
      prior_dist = context__.vals_i("prior_dist")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "prior_dist",
        prior_dist, 0);
      current_statement__ = 48;
      stan::math::check_less_or_equal(function__, "prior_dist", prior_dist, 1);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "prior_PD", "int",
        std::vector<size_t>{});
      prior_PD = std::numeric_limits<int>::min();
      current_statement__ = 49;
      prior_PD = context__.vals_i("prior_PD")[(1 - 1)];
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "prior_PD", prior_PD, 0);
      current_statement__ = 49;
      stan::math::check_less_or_equal(function__, "prior_PD", prior_PD, 1);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "eta", "double",
        std::vector<size_t>{});
      eta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 50;
      eta = context__.vals_r("eta")[(1 - 1)];
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "eta", eta, 0);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 51;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("N", "J", J);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{static_cast<size_t>(J)});
      N = std::vector<int>(J, std::numeric_limits<int>::min());
      current_statement__ = 53;
      N = context__.vals_i("N");
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 54;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 54;
      stan::math::check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 54;
      stan::math::check_less_or_equal(function__, "K", K, stan::math::min(N));
      current_statement__ = 55;
      stan::math::validate_non_negative_index("xbarR_inv", "J", J);
      current_statement__ = 56;
      stan::math::validate_non_negative_index("xbarR_inv", "K", K);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "xbarR_inv", "double",
        std::vector<size_t>{static_cast<size_t>(J), static_cast<size_t>(K)});
      xbarR_inv = std::vector<Eigen::Matrix<double,-1,1>>(J,
                    Eigen::Matrix<double,-1,1>::Constant(K,
                      std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> xbarR_inv_flat__;
        current_statement__ = 57;
        xbarR_inv_flat__ = context__.vals_r("xbarR_inv");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 57;
          for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
            current_statement__ = 57;
            stan::model::assign(xbarR_inv, xbarR_inv_flat__[(pos__ - 1)],
              "assigning variable xbarR_inv", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 57;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 58;
      stan::math::validate_non_negative_index("ybar", "J", J);
      current_statement__ = 59;
      context__.validate_dims("data initialization", "ybar", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      ybar = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 59;
      ybar = context__.vals_r("ybar");
      current_statement__ = 60;
      context__.validate_dims("data initialization", "center_y", "double",
        std::vector<size_t>{});
      center_y = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 60;
      center_y = context__.vals_r("center_y")[(1 - 1)];
      current_statement__ = 61;
      stan::math::validate_non_negative_index("s_Y", "J", J);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "s_Y", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      s_Y = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 62;
      s_Y = context__.vals_r("s_Y");
      current_statement__ = 62;
      stan::math::check_greater_or_equal(function__, "s_Y", s_Y, 0);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("Rb", "J", J);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("Rb", "K", K);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "Rb", "double",
        std::vector<size_t>{static_cast<size_t>(J), static_cast<size_t>(K)});
      Rb = std::vector<Eigen::Matrix<double,-1,1>>(J,
             Eigen::Matrix<double,-1,1>::Constant(K,
               std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Rb_flat__;
        current_statement__ = 65;
        Rb_flat__ = context__.vals_r("Rb");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 65;
          for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
            current_statement__ = 65;
            stan::model::assign(Rb, Rb_flat__[(pos__ - 1)],
              "assigning variable Rb", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 65;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 66;
      stan::math::validate_non_negative_index("SSR", "J", J);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "SSR", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      SSR = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 67;
      SSR = context__.vals_r("SSR");
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "SSR", SSR, 0);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("R_inv", "J", J);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("R_inv", "K", K);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("R_inv", "K", K);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "R_inv", "double",
        std::vector<size_t>{static_cast<size_t>(J), static_cast<size_t>(K),
          static_cast<size_t>(K)});
      R_inv = std::vector<Eigen::Matrix<double,-1,-1>>(J,
                Eigen::Matrix<double,-1,-1>::Constant(K, K,
                  std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> R_inv_flat__;
        current_statement__ = 71;
        R_inv_flat__ = context__.vals_r("R_inv");
        current_statement__ = 71;
        pos__ = 1;
        current_statement__ = 71;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 71;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 71;
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              current_statement__ = 71;
              stan::model::assign(R_inv, R_inv_flat__[(pos__ - 1)],
                "assigning variable R_inv", stan::model::index_uni(sym3__),
                stan::model::index_uni(sym2__),
                stan::model::index_uni(sym1__));
              current_statement__ = 71;
              pos__ = (pos__ + 1);
            }
          }
        }
      }
      current_statement__ = 72;
      half_K = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 72;
      half_K = (0.5 * K);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("sqrt_inv_N", "J", J);
      current_statement__ = 74;
      sqrt_inv_N = std::vector<double>(J,
                     std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 75;
      stan::math::validate_non_negative_index("sqrt_Nm1", "J", J);
      current_statement__ = 76;
      sqrt_Nm1 = std::vector<double>(J,
                   std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 80;
      for (int j = 1; j <= J; ++j) {
        current_statement__ = 77;
        stan::model::assign(sqrt_inv_N,
          stan::math::sqrt((1.0 /
            stan::model::rvalue(N, "N", stan::model::index_uni(j)))),
          "assigning variable sqrt_inv_N", stan::model::index_uni(j));
        current_statement__ = 78;
        stan::model::assign(sqrt_Nm1,
          stan::math::sqrt(
            (stan::model::rvalue(N, "N", stan::model::index_uni(j)) - 1.0)),
          "assigning variable sqrt_Nm1", stan::model::index_uni(j));
      }
      current_statement__ = 81;
      u_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 81;
      u_1dim__ = (stan::math::logical_gt(K, 1) ? J : 0);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("u", "K > 1 ? J : 0", u_1dim__);
      current_statement__ = 82;
      u_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 82;
      u_2dim__ = (stan::math::logical_gt(K, 1) ? K : 2);
      current_statement__ = 82;
      stan::math::validate_unit_vector_index("u", "K > 1 ? K : 2", u_2dim__);
      current_statement__ = 83;
      z_alpha_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 83;
      z_alpha_1dim__ = (J * has_intercept);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("z_alpha", "J * has_intercept",
        z_alpha_1dim__);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("R2", "J", J);
      current_statement__ = 85;
      log_omega_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 85;
      log_omega_1dim__ = (J * (1 - prior_PD));
      current_statement__ = 85;
      stan::math::validate_non_negative_index("log_omega",
        "J * (1 - prior_PD)", log_omega_1dim__);
      current_statement__ = 86;
      alpha_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 86;
      alpha_1dim__ = (J * has_intercept);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("alpha", "J * has_intercept",
        alpha_1dim__);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("theta", "J", J);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("theta", "K", K);
      current_statement__ = 89;
      stan::math::validate_non_negative_index("sigma", "J", J);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("mean_PPD", "J", J);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("beta", "J", J);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("beta", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (u_1dim__ * u_2dim__) + z_alpha_1dim__ + J +
      log_omega_1dim__;
  }
  inline std::string model_name() const final {
    return "model_lm";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ = "model_lm_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      current_statement__ = 1;
      u = in__.template read_constrain_unit_vector<
            std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
            jacobian__>(lp__, u_1dim__, u_2dim__);
      std::vector<local_scalar_t__> z_alpha =
        std::vector<local_scalar_t__>(z_alpha_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      z_alpha = in__.template read<
                  std::vector<local_scalar_t__>>(z_alpha_1dim__);
      std::vector<local_scalar_t__> R2 =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 3;
      R2 = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>((stan::math::logical_gt(K, 1) ? 0 : -1), 1, lp__, J);
      Eigen::Matrix<local_scalar_t__,-1,1> log_omega =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(log_omega_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      log_omega = in__.template read<
                    Eigen::Matrix<local_scalar_t__,-1,1>>(log_omega_1dim__);
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(alpha_1dim__, DUMMY_VAR__);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> theta =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(J,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      std::vector<local_scalar_t__> sigma =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 23;
      for (int j = 1; j <= J; ++j) {
        local_scalar_t__ Delta_y = DUMMY_VAR__;
        current_statement__ = 10;
        Delta_y = (stan::math::logical_eq(prior_PD, 0) ? (stan::model::rvalue(
                                                            s_Y, "s_Y",
                                                            stan::model::index_uni(
                                                              j))
          *
          stan::math::exp(
            stan::model::rvalue(log_omega, "log_omega",
              stan::model::index_uni(j)))) : 1);
        current_statement__ = 13;
        if (stan::math::logical_gt(K, 1)) {
          current_statement__ = 12;
          stan::model::assign(theta,
            stan::math::multiply(
              stan::math::multiply(
                stan::math::multiply(
                  stan::model::rvalue(u, "u", stan::model::index_uni(j)),
                  stan::math::sqrt(
                    stan::model::rvalue(R2, "R2", stan::model::index_uni(j)))),
                stan::model::rvalue(sqrt_Nm1, "sqrt_Nm1",
                  stan::model::index_uni(j))), Delta_y),
            "assigning variable theta", stan::model::index_uni(j));
        } else {
          current_statement__ = 11;
          stan::model::assign(theta,
            ((stan::model::rvalue(R2, "R2", stan::model::index_uni(j)) *
            stan::model::rvalue(sqrt_Nm1, "sqrt_Nm1",
              stan::model::index_uni(j))) * Delta_y),
            "assigning variable theta", stan::model::index_uni(j),
            stan::model::index_uni(1));
        }
        current_statement__ = 14;
        stan::model::assign(sigma, (Delta_y *
          stan::math::sqrt((1 -
            stan::model::rvalue(R2, "R2", stan::model::index_uni(j))))),
          "assigning variable sigma", stan::model::index_uni(j));
        current_statement__ = 21;
        if (stan::math::logical_eq(has_intercept, 1)) {
          current_statement__ = 19;
          if (stan::math::logical_eq(prior_dist_for_intercept, 0)) {
            current_statement__ = 18;
            stan::model::assign(alpha,
              stan::model::rvalue(z_alpha, "z_alpha",
                stan::model::index_uni(j)), "assigning variable alpha",
              stan::model::index_uni(j));
          } else {
            current_statement__ = 17;
            if (stan::math::logical_eq(prior_scale_for_intercept, 0)) {
              current_statement__ = 16;
              stan::model::assign(alpha,
                (((stan::model::rvalue(z_alpha, "z_alpha",
                     stan::model::index_uni(j)) * Delta_y) *
                stan::model::rvalue(sqrt_inv_N, "sqrt_inv_N",
                  stan::model::index_uni(j))) + prior_mean_for_intercept),
                "assigning variable alpha", stan::model::index_uni(j));
            } else {
              current_statement__ = 15;
              stan::model::assign(alpha,
                ((stan::model::rvalue(z_alpha, "z_alpha",
                    stan::model::index_uni(j)) * prior_scale_for_intercept) +
                prior_mean_for_intercept), "assigning variable alpha",
                stan::model::index_uni(j));
            }
          }
        }
      }
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 0);
      {
        current_statement__ = 33;
        if (stan::math::logical_eq(prior_PD, 0)) {
          current_statement__ = 32;
          for (int j = 1; j <= J; ++j) {
            local_scalar_t__ shift = DUMMY_VAR__;
            current_statement__ = 29;
            shift = stan::math::dot_product(
                      stan::model::rvalue(xbarR_inv, "xbarR_inv",
                        stan::model::index_uni(j)),
                      stan::model::rvalue(theta, "theta",
                        stan::model::index_uni(j)));
            current_statement__ = 30;
            lp_accum__.add(mvn_ols_qr_lpdf<false>(
                             stan::model::rvalue(theta, "theta",
                               stan::model::index_uni(j)),
                             stan::model::rvalue(Rb, "Rb",
                               stan::model::index_uni(j)),
                             (stan::math::logical_eq(has_intercept, 1) ? (
                             stan::model::rvalue(alpha, "alpha",
                               stan::model::index_uni(j)) + shift) : shift),
                             stan::model::rvalue(ybar, "ybar",
                               stan::model::index_uni(j)),
                             stan::model::rvalue(SSR, "SSR",
                               stan::model::index_uni(j)),
                             stan::model::rvalue(sigma, "sigma",
                               stan::model::index_uni(j)),
                             stan::model::rvalue(N, "N",
                               stan::model::index_uni(j)), pstream__));
          }
        }
        current_statement__ = 35;
        if ((stan::math::primitive_value(
               stan::math::logical_eq(has_intercept, 1))
            &&
            stan::math::primitive_value(
              stan::math::logical_gt(prior_dist_for_intercept, 0)))) {
          current_statement__ = 34;
          lp_accum__.add(stan::math::normal_lpdf<false>(z_alpha, 0, 1));
        }
        current_statement__ = 43;
        if (stan::math::logical_eq(prior_dist, 1)) {
          current_statement__ = 41;
          if (stan::math::logical_gt(K, 1)) {
            current_statement__ = 40;
            lp_accum__.add(stan::math::beta_lpdf<false>(R2, half_K, eta));
          } else {
            current_statement__ = 36;
            stan::math::validate_non_negative_index("R2_abs", "J", J);
            std::vector<local_scalar_t__> R2_abs =
              std::vector<local_scalar_t__>(J, DUMMY_VAR__);
            current_statement__ = 37;
            stan::model::assign(R2_abs, stan::math::abs(R2),
              "assigning variable R2_abs");
            current_statement__ = 38;
            lp_accum__.add((stan::math::beta_lpdf<false>(
                              stan::math::square(R2), half_K, eta) +
              stan::math::sum(stan::math::log(R2_abs))));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_lm_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<Eigen::Matrix<double,-1,1>> u =
        std::vector<Eigen::Matrix<double,-1,1>>(u_1dim__,
          Eigen::Matrix<double,-1,1>::Constant(u_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 1;
      u = in__.template read_constrain_unit_vector<
            std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
            jacobian__>(lp__, u_1dim__, u_2dim__);
      std::vector<double> z_alpha =
        std::vector<double>(z_alpha_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      z_alpha = in__.template read<
                  std::vector<local_scalar_t__>>(z_alpha_1dim__);
      std::vector<double> R2 =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      R2 = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>((stan::math::logical_gt(K, 1) ? 0 : -1), 1, lp__, J);
      Eigen::Matrix<double,-1,1> log_omega =
        Eigen::Matrix<double,-1,1>::Constant(log_omega_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      log_omega = in__.template read<
                    Eigen::Matrix<local_scalar_t__,-1,1>>(log_omega_1dim__);
      std::vector<double> alpha =
        std::vector<double>(alpha_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> theta =
        std::vector<Eigen::Matrix<double,-1,1>>(J,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<double> sigma =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
          out__.write(u[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(z_alpha);
      out__.write(R2);
      out__.write(log_omega);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 23;
      for (int j = 1; j <= J; ++j) {
        double Delta_y = std::numeric_limits<double>::quiet_NaN();
        current_statement__ = 10;
        Delta_y = (stan::math::logical_eq(prior_PD, 0) ? (stan::model::rvalue(
                                                            s_Y, "s_Y",
                                                            stan::model::index_uni(
                                                              j))
          *
          stan::math::exp(
            stan::model::rvalue(log_omega, "log_omega",
              stan::model::index_uni(j)))) : 1);
        current_statement__ = 13;
        if (stan::math::logical_gt(K, 1)) {
          current_statement__ = 12;
          stan::model::assign(theta,
            stan::math::multiply(
              stan::math::multiply(
                stan::math::multiply(
                  stan::model::rvalue(u, "u", stan::model::index_uni(j)),
                  stan::math::sqrt(
                    stan::model::rvalue(R2, "R2", stan::model::index_uni(j)))),
                stan::model::rvalue(sqrt_Nm1, "sqrt_Nm1",
                  stan::model::index_uni(j))), Delta_y),
            "assigning variable theta", stan::model::index_uni(j));
        } else {
          current_statement__ = 11;
          stan::model::assign(theta,
            ((stan::model::rvalue(R2, "R2", stan::model::index_uni(j)) *
            stan::model::rvalue(sqrt_Nm1, "sqrt_Nm1",
              stan::model::index_uni(j))) * Delta_y),
            "assigning variable theta", stan::model::index_uni(j),
            stan::model::index_uni(1));
        }
        current_statement__ = 14;
        stan::model::assign(sigma, (Delta_y *
          stan::math::sqrt((1 -
            stan::model::rvalue(R2, "R2", stan::model::index_uni(j))))),
          "assigning variable sigma", stan::model::index_uni(j));
        current_statement__ = 21;
        if (stan::math::logical_eq(has_intercept, 1)) {
          current_statement__ = 19;
          if (stan::math::logical_eq(prior_dist_for_intercept, 0)) {
            current_statement__ = 18;
            stan::model::assign(alpha,
              stan::model::rvalue(z_alpha, "z_alpha",
                stan::model::index_uni(j)), "assigning variable alpha",
              stan::model::index_uni(j));
          } else {
            current_statement__ = 17;
            if (stan::math::logical_eq(prior_scale_for_intercept, 0)) {
              current_statement__ = 16;
              stan::model::assign(alpha,
                (((stan::model::rvalue(z_alpha, "z_alpha",
                     stan::model::index_uni(j)) * Delta_y) *
                stan::model::rvalue(sqrt_inv_N, "sqrt_inv_N",
                  stan::model::index_uni(j))) + prior_mean_for_intercept),
                "assigning variable alpha", stan::model::index_uni(j));
            } else {
              current_statement__ = 15;
              stan::model::assign(alpha,
                ((stan::model::rvalue(z_alpha, "z_alpha",
                    stan::model::index_uni(j)) * prior_scale_for_intercept) +
                prior_mean_for_intercept), "assigning variable alpha",
                stan::model::index_uni(j));
            }
          }
        }
      }
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 0);
      if (emit_transformed_parameters__) {
        out__.write(alpha);
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
            out__.write(theta[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        out__.write(sigma);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<double> mean_PPD =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> beta =
        std::vector<Eigen::Matrix<double,-1,1>>(J,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 28;
      for (int j = 1; j <= J; ++j) {
        double shift = std::numeric_limits<double>::quiet_NaN();
        current_statement__ = 24;
        shift = stan::math::dot_product(
                  stan::model::rvalue(xbarR_inv, "xbarR_inv",
                    stan::model::index_uni(j)),
                  stan::model::rvalue(theta, "theta",
                    stan::model::index_uni(j)));
        current_statement__ = 25;
        stan::model::assign(mean_PPD,
          stan::math::normal_rng(
            (stan::math::logical_eq(has_intercept, 1) ? (stan::model::rvalue(
                                                           alpha, "alpha",
                                                           stan::model::index_uni(
                                                             j)) +
            shift) : shift),
            (stan::model::rvalue(sigma, "sigma", stan::model::index_uni(j)) *
            stan::model::rvalue(sqrt_inv_N, "sqrt_inv_N",
              stan::model::index_uni(j))), base_rng__),
          "assigning variable mean_PPD", stan::model::index_uni(j));
        current_statement__ = 26;
        stan::model::assign(beta,
          stan::math::multiply(
            stan::model::rvalue(R_inv, "R_inv", stan::model::index_uni(j)),
            stan::model::rvalue(theta, "theta", stan::model::index_uni(j))),
          "assigning variable beta", stan::model::index_uni(j));
      }
      out__.write(mean_PPD);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          out__.write(beta[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
          current_statement__ = 1;
          stan::model::assign(u, in__.read<local_scalar_t__>(),
            "assigning variable u", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write_free_unit_vector(u);
      std::vector<local_scalar_t__> z_alpha =
        std::vector<local_scalar_t__>(z_alpha_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(z_alpha,
        in__.read<std::vector<local_scalar_t__>>(z_alpha_1dim__),
        "assigning variable z_alpha");
      out__.write(z_alpha);
      std::vector<local_scalar_t__> R2 =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(R2, in__.read<std::vector<local_scalar_t__>>(J),
        "assigning variable R2");
      out__.write_free_lub((stan::math::logical_gt(K, 1) ? 0 : -1), 1, R2);
      Eigen::Matrix<local_scalar_t__,-1,1> log_omega =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(log_omega_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(log_omega,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(log_omega_1dim__),
        "assigning variable log_omega");
      out__.write(log_omega);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "u", "double",
        std::vector<size_t>{static_cast<size_t>(u_1dim__),
          static_cast<size_t>(u_2dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "z_alpha",
        "double", std::vector<size_t>{static_cast<size_t>(z_alpha_1dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "R2", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "log_omega",
        "double", std::vector<size_t>{static_cast<size_t>(log_omega_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> u_flat__;
        current_statement__ = 1;
        u_flat__ = context__.vals_r("u");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
            current_statement__ = 1;
            stan::model::assign(u, u_flat__[(pos__ - 1)],
              "assigning variable u", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 1;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_unit_vector(u);
      std::vector<local_scalar_t__> z_alpha =
        std::vector<local_scalar_t__>(z_alpha_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      z_alpha = context__.vals_r("z_alpha");
      out__.write(z_alpha);
      std::vector<local_scalar_t__> R2 =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 3;
      R2 = context__.vals_r("R2");
      out__.write_free_lub((stan::math::logical_gt(K, 1) ? 0 : -1), 1, R2);
      Eigen::Matrix<local_scalar_t__,-1,1> log_omega =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(log_omega_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> log_omega_flat__;
        current_statement__ = 4;
        log_omega_flat__ = context__.vals_r("log_omega");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= log_omega_1dim__; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(log_omega, log_omega_flat__[(pos__ - 1)],
            "assigning variable log_omega", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(log_omega);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"u", "z_alpha", "R2", "log_omega"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"alpha", "theta", "sigma"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"mean_PPD", "beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    u_1dim__),
                                                 static_cast<size_t>(u_2dim__)},
                std::vector<size_t>{static_cast<size_t>(z_alpha_1dim__)},
                std::vector<size_t>{static_cast<size_t>(J)},
                std::vector<size_t>{static_cast<size_t>(log_omega_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(alpha_1dim__)},
             std::vector<size_t>{static_cast<size_t>(J),
               static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(J)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(J)},
             std::vector<size_t>{static_cast<size_t>(J),
               static_cast<size_t>(K)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= z_alpha_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "z_alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "R2" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= log_omega_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "log_omega" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          param_names__.emplace_back(std::string() + "theta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "sigma" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "mean_PPD" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= z_alpha_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "z_alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "R2" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= log_omega_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "log_omega" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          param_names__.emplace_back(std::string() + "theta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "sigma" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "mean_PPD" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= J; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(u_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(u_2dim__) + "}},\"block\":\"parameters\"},{\"name\":\"z_alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(z_alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"R2\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log_omega\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_omega_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"mean_PPD\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(u_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(u_2dim__) + "}},\"block\":\"parameters\"},{\"name\":\"z_alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(z_alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"R2\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log_omega\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_omega_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"mean_PPD\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((u_1dim__ * u_2dim__) + z_alpha_1dim__) +
      J) + log_omega_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      (((alpha_1dim__ + (J * K)) + J));
    const size_t num_gen_quantities = emit_generated_quantities * ((J + (J *
      K)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((u_1dim__ * u_2dim__) + z_alpha_1dim__) +
      J) + log_omega_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      (((alpha_1dim__ + (J * K)) + J));
    const size_t num_gen_quantities = emit_generated_quantities * ((J + (J *
      K)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_lm_namespace::model_lm;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_lm_namespace::profiles__;
}
#endif
#endif
