% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity.R
\name{add_entity_value}
\alias{add_entity_value}
\title{Add entity value to RO-Crate}
\usage{
add_entity_value(rocrate, id, key, value, overwrite = TRUE)
}
\arguments{
\item{rocrate}{RO-Crate object, see \link{rocrate}.}

\item{id}{String with the ID of the RO-Crate entity within \verb{@graph}.}

\item{key}{String with the \code{key} of the entity with \code{id} to be modified.}

\item{value}{String with the \code{value} for \code{key}.}

\item{overwrite}{Boolean flag to indicate if the existing value (if any),
should be overwritten (default: \code{TRUE}).}
}
\value{
RO-Crate object.
}
\description{
Add entity value to RO-Crate, under entity with \verb{@id} = \code{{id}}, using the
pair \code{{key}}-\code{{value}} within \verb{@graph}.
}
\examples{
basic_crate <- rocrate()

# create entity for an organisation
organisation_uol <- rocrateR::entity(
  x = "https://ror.org/04xs57h96",
  type = "Organization",
  name = "University of Liverpool",
  url = "http://www.liv.ac.uk"
)

# create an entity for a person
person_rvd <- rocrateR::entity(
  x = "https://orcid.org/0000-0001-5036-8661",
  type = "Person",
  name = "Roberto Villegas-Diaz",
  affiliation = list(`@id` = organisation_uol$`@id`)
)

basic_crate_v2 <- basic_crate |>
  rocrateR::add_entity_value(id = "./", key = "author", value = list(`@id` = person_rvd$`@id`))
}
