% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roclearn.R
\name{roclearn}
\alias{roclearn}
\title{Fit a linear model}
\usage{
roclearn(
  X,
  y,
  lambda,
  penalty = "ridge",
  param.penalty = NULL,
  loss = "hinge",
  approx = NULL,
  intercept = TRUE,
  target.perf = list(),
  param.convergence = list()
)
}
\arguments{
\item{X}{Predictor matrix or data.frame (categorical variables are
automatically one-hot encoded).}

\item{y}{Response vector with class labels in \{-1, 1\}. Labels given as
\{0, 1\} or as a two-level factor/character are automatically converted
to this format.}

\item{lambda}{Positive scalar regularization parameter.}

\item{penalty}{Regularization penalty type:
\code{"ridge"} (default), \code{"lasso"}, \code{"elastic"},
\code{"alasso"}, \code{"scad"}, or \code{"mcp"}.}

\item{param.penalty}{Penalty-specific parameter:
\itemize{
\item Ignored for \code{"ridge"} and \code{"lasso"}.
\item Mixing parameter \eqn{\alpha \in (0,1)} for \code{"elastic"}. Default is 0.5.
\item Adaptive weight exponent \eqn{\gamma > 0} for \code{"alasso"}. Default is 1.
\item Tuning parameter (default 3.7) for \code{"scad"} and \code{"mcp"}.
}}

\item{loss}{Surrogate loss function type. One of:
\code{"hinge"} (default), \code{"hinge2"} (squared hinge),
\code{"logistic"}, or \code{"exponential"}.}

\item{approx}{Logical; enables a scalable approximation to accelerate training.
The default is \code{TRUE} when \code{nrow(X) >= 1000}, and \code{FALSE} otherwise.
For details about how approximation is applied, see the \code{details} section.}

\item{intercept}{Logical; include an intercept in the model (default \code{TRUE}).}

\item{target.perf}{List with target sensitivity and specificity used when
estimating the intercept (defaults to 0.9 each).}

\item{param.convergence}{List of convergence controls (e.g., \code{maxiter},
\code{eps}). Default is \code{list(maxiter = 5e4, eps = 1e-4)}.}
}
\value{
An object of class \code{"roclearn"}, a list containing:
\itemize{
\item \code{beta.hat} — estimated coefficient vector.
\item \code{intercept} — fitted intercept (if applicable).
\item \code{lambda}, \code{penalty}, \code{param.penalty}, \code{loss}.
\item \code{approx}, \code{B} (number of sampled pairs if approximation used).
\item \code{time} — training time (seconds).
\item \code{nobs}, \code{p} — number of observations and predictors.
\item \code{converged}, \code{n.iter} — convergence information.
\item \code{preprocessing} — details on categorical variables,
removed columns, and column names.
\item \code{call} — the function call.
}
}
\description{
Fit a linear model
}
\details{
For large-scale data, the model is computationally prohibitive because its
loss is a U-statistic involving a double summation. To reduce this burden,
the package adopts an efficient algorithm based on an incomplete U-statistic,
which approximates the loss with a single summation. These approximations
substantially reduce computational cost and accelerate training, while
maintaining accuracy, making the model feasible for large-scale datasets.
This option is available when \code{approx = TRUE}.
}
\examples{
set.seed(123)
n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos
X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

fit <- roclearn(X, y, lambda = 0.1, penalty = "ridge", approx=TRUE)
}
