% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.kroclearn.R
\name{predict.kroclearn}
\alias{predict.kroclearn}
\title{Predictions from a fitted kernel model}
\usage{
\method{predict}{kroclearn}(object, newdata, type = c("class", "response"), ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"kroclearn"} (kernel).}

\item{newdata}{A data frame or matrix of predictors for which predictions
are desired. Categorical variables are automatically dummy-encoded and
aligned to the training structure.}

\item{type}{Prediction type: \code{"class"} for \{-1, 1\} labels, or
\code{"response"} for raw decision scores.}

\item{...}{Not used.}
}
\value{
A numeric vector of predictions (\{-1, 1\}) if \code{type = "class"},
or raw decision scores if \code{type = "response"}.
}
\description{
Generate predictions from a fitted kernel model.
}
\examples{
set.seed(123)
n <- 100
r <- sqrt(runif(n, 0.05, 1))
theta <- runif(n, 0, 2*pi)
X <- cbind(r * cos(theta), r * sin(theta))
y <- ifelse(r < 0.5, 1, -1)

fit <- kroclearn(X, y, lambda = 0.1, kernel = "radial", approx=TRUE)

# Predict classes {-1, 1}
predict(fit, X, type = "class")

# Predict decision scores
predict(fit, X, type = "response")
}
\seealso{
\code{\link{kroclearn}}, \code{\link{cv.kroclearn}}
}
