% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\alias{mdl}
\alias{mdl.character}
\alias{mdl.lm}
\alias{mdl.glm}
\alias{mdl.coxph}
\alias{mdl.default}
\alias{model}
\title{Model Prototypes}
\usage{
mdl(x = unspecified(), ...)

\method{mdl}{character}(
  x,
  formulas,
  parameter_estimates = data.frame(),
  summary_info = list(),
  data_name,
  strata_variable = NA_character_,
  strata_level = NA_character_,
  ...
)

\method{mdl}{lm}(
  x = unspecified(),
  formulas = fmls(),
  data_name = character(),
  strata_variable = character(),
  strata_level = character(),
  ...
)

\method{mdl}{glm}(
  x = unspecified(),
  formulas = fmls(),
  data_name = character(),
  strata_variable = character(),
  strata_level = character(),
  ...
)

\method{mdl}{coxph}(
  x = unspecified(),
  formulas = fmls(),
  data_name = character(),
  strata_variable = character(),
  strata_level = character(),
  ...
)

\method{mdl}{default}(x, ...)

model(x = unspecified(), ...)
}
\arguments{
\item{x}{Model object or representation}

\item{...}{Arguments to be passed to or from other methods}

\item{formulas}{Formula(s) given as either an \code{formula} or as a \code{fmls} object}

\item{parameter_estimates}{A \code{data.frame} that contains columns
representing terms and individual estimates or coefficients, can be
accompanied by additional statistic columns. By default, assumes
\itemize{
\item \strong{term} = term name
\item \strong{estimate} = estimate or coefficient
}}

\item{summary_info}{A \code{list} that contains columns representing
summary statistic of a model. By default, assumes...
\itemize{
\item \strong{nobs} = number of observations
\item \strong{degrees_freedom} = degrees of freedom
\item \strong{statistic} = test statistic
\item \strong{p_value} = p-value for overall model
\item \strong{var_cov} = variance-covariance matrix for predicted coefficients
}}

\item{data_name}{String representing name of dataset that was used}

\item{strata_variable}{String of a term that served as a stratifying
variable}

\item{strata_level}{Value of the level of the term specified by
\code{strata_variable}}
}
\value{
An object of the \code{mdl} class, which is essentially an equal-length
list of parameters that describe a single model. It retains the original
formula call and the related roles in the formula.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
