% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R
\name{load}
\alias{load}
\title{Load any Kriging Model from a file storage. Back to base::load if not a Kriging object.}
\usage{
load(filename, ...)
}
\arguments{
\item{filename}{A file holding any Kriging object.}

\item{...}{Arguments used by base::load.}
}
\value{
The loaded "*"Kriging object, or nothing if base::load is used (update parent environment).
}
\description{
Load any Kriging Model from a file storage. Back to base::load if not a Kriging object.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

outfile = tempfile("k.json") 
save(k,outfile)

print(load(outfile))
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
