% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_manuscripts.R
\name{remove_manuscript}
\alias{remove_manuscript}
\title{Remove Manuscript from Environment}
\usage{
remove_manuscript(manuscript = NULL, envir = parent.frame(1))
}
\arguments{
\item{manuscript}{A character vector of revise_manuscript names
that exist in \code{envir}.}

\item{envir}{The environment from which to remove
the manuscript.}
}
\value{
Invisibly returns \code{TRUE} if successful, and \code{FALSE}
otherwise.
}
\description{
Removes a revise_manuscript from a given environment by name.
}
\examples{
temp_file <- tempfile(fileext = ".Rmd")
write("`r 1 + 1", file = temp_file)
read_manuscript(temp_file)
result <- remove_manuscript(list_manuscripts()[1])
# See that remove_manuscript() silently returns TRUE
print(result)
# See that there are no more manuscripts in envir
list_manuscripts()

}
