% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{printVerificationTable}
\alias{printVerificationTable}
\title{Print Verification Table}
\usage{
printVerificationTable(verificationTab, RIperc)
}
\arguments{
\item{verificationTab}{(data.frame) containing the verification table. Must include the following columns:
\itemize{
\item Percentile: The percentile values.
\item RIDataPointEst: Point estimates for RI Data.
\item RIDataMarginLow: Lower margins for RI Data.
\item RIDataMarginHigh: Upper margins for RI Data.
\item RITestPointEst: Point estimates for RI Cand.
\item RITestMarginLow: Lower margins for RI Cand.
\item RITestMarginHigh: Upper margins for RI Cand.
\item OverlapPointEst: Logical indicating if point estimates overlap.
\item OverlapMargins: Logical indicating if margins overlap.
}}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}
}
\value{
None. Prints the verification table to the console.
}
\description{
This function prints a formatted verification table for reference intervals
}
\examples{
\dontrun{
df <- data.frame(
	Percentile = c(0.025, 0.975),
	RICandPointEst = c(12, 65),
	RICandMarginLow = c(10.9013, 60.2780),
	RICandMarginHigh = c(13.86800, 72.64152),
	RIDataPointEst = c(13, 69),
	RIDataMarginLow = c(11.60130, 63.77848),
	RIDataMarginHigh = c(14.39861, 74.22152),
	OverlapPointEst = c(TRUE, TRUE),
	OverlapMargins = c(TRUE, TRUE)
)
 
RIperc <- c(0.025, 0.975)
printVerificationTable(df, RIperc)
}
}
