% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{is.ref}
\alias{is.ref}
\alias{is.sref}
\alias{is.rfexpr}
\alias{is.slice}
\alias{is.a.ref}
\title{Is Object a Reference?}
\usage{
is.ref(x)

is.sref(x)

is.rfexpr(x)

is.slice(x)

is.a.ref(x)
}
\arguments{
\item{x}{object of any class}
}
\value{
\code{TRUE} if \code{x} is a reference object, otherwise \code{FALSE}
}
\description{
Check whether an R Object inherits a reference class.
}
\section{Functions}{
\itemize{
\item \code{is.sref}: check whether object is an 'sref' object

\item \code{is.rfexpr}: check whether object is a reference expression

\item \code{is.slice}: check whether object references a slice of a vector

\item \code{is.a.ref}: check whether object is any type of reference class
}}

\examples{
# Create a vectors of random numbers
x <- rnorm(10)

# Create a reference to the random numbers
ref_to_x <- ref(x)

is.ref(ref_to_x) # TRUE

}
