% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incr.R
\name{incr}
\alias{incr}
\title{Increment Value In Place}
\usage{
incr(x, by = 1)
}
\arguments{
\item{x}{object to be incremented; can be a symbol, character, or extraction language object.}

\item{by}{value to increase \code{x} by; defaults to \code{1}.}
}
\value{
the value of \code{x} incremented by \code{by}, invisibly
}
\description{
Increase the value of an object on the search path. Equivalent to \code{x++} or \code{x += by} in other languages.
}
\details{
\code{incr} quotes object \code{x}, then attempts to determine the primary object to be modified.
For example, \code{z} will be the 'primary object' in \code{incr(z[1:4])}. \code{incr} then searches
for the primary object in the search path and records the environment. \code{x <- x + by} is then
evaluated within the recorded environment.

The quoted object can be a symbol or character object. It can also be language object, though the primary
call must be either \code{`$`}, \code{`[`}, or \code{`[[`}. These can be nested. For example, \code{x[1]}
or \code{x[2, 1][3]} is acceptable, but \code{sqrt(x)} is not.

See \code{\link{decr}} to decrease the value.
}
\examples{
z <- 1:10

incr(z)
identical(z, as.numeric(2:11))       # TRUE

incr(z[1:3], by=2)
identical(z[1:3], as.numeric(4:6))   # TRUE

l <- list(a = 1, b = 2)
decr(l$a)
l$a == 0   # TRUE

decr(l$b, by = 4)
l$b == -2  # TRUE
}
