% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getset.R
\name{Extract}
\alias{Extract}
\alias{$.ref}
\alias{$.sref}
\alias{$<-.ref}
\alias{$<-.sref}
\alias{[.ref}
\alias{[.sref}
\alias{[<-.ref}
\alias{[<-.sref}
\alias{[[.ref}
\alias{[[.sref}
\alias{[[<-.ref}
\alias{[[<-.sref}
\title{Extract or Replace Parts of a Referenced Object}
\usage{
\method{$}{ref}(x, name)

\method{$}{sref}(x, ..., value)

\method{$}{ref}(x, name) <- value

\method{$}{sref}(x, ...) <- value

\method{[}{ref}(x, ...)

\method{[}{sref}(x, ..., value)

\method{[}{ref}(x, ...) <- value

\method{[}{sref}(x, ...) <- value

\method{[[}{ref}(x, ...)

\method{[[}{sref}(x, ..., value)

\method{[[}{ref}(x, ...) <- value

\method{[[}{sref}(x, ...) <- value
}
\arguments{
\item{x}{object of class \code{"ref"}}

\item{name}{literal character string or a name}

\item{...}{values passed to the function after dereferencing}

\item{value}{object, usually of a similar class as the dereferenced value of \code{x}, used for assigning in place}
}
\value{
Object of class \code{"ref"}
}
\description{
Operators acting on a \code{\link{ref}} object that extract part of the underlying object
at the supplied indices, or replaces parts. These operators modify or extract from the
object that is referenced, not the reference! Use \code{\link{sref}} is this behavior
is undesirable.
}
\examples{
x <- list(
  a = 1,
  b = "hello",
  "world"
)
ref_to_x <- ref(x)

# Extract parts of 'x' from the reference
ref_to_x$a
ref_to_x[2:3]
ref_to_x[["b"]]

# Replace parts of 'x' through the reference
ref_to_x[["a"]] <- 100
x$a == 100

ref_to_x$b <- "bye"
x$b == "bye"

ref_to_x[2:3] <- list(2, 3)
print(x)



}
