% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_parquet.R
\name{write_rcdf_parquet}
\alias{write_rcdf_parquet}
\title{Write RCDF data to Parquet files}
\usage{
write_rcdf_parquet(
  data,
  path,
  ...,
  parent_dir = NULL,
  primary_key = NULL,
  ignore_duplicates = TRUE
)
}
\arguments{
\item{data}{A list where each element is a data frame or tibble that will be written to a Parquet file.}

\item{path}{The directory path where the Parquet files will be written.}

\item{...}{Additional arguments passed to \code{rcdf::write_parquet()} while writing each Parquet file.}

\item{parent_dir}{An optional parent directory to be included in the path where the files will be written.}

\item{primary_key}{A \code{data.frame} or \code{tibble} that includes at least two columns: \code{file} and \code{pk_field_name}.}

\item{ignore_duplicates}{A \code{logical} flag. If \code{TRUE}, a warning is issued when duplicates are found. If \code{FALSE}, the function stops with an error.}
}
\value{
A character vector of file paths to the written Parquet files.
}
\description{
This function writes an RCDF object (a list of data frames) to multiple Parquet files. Each data frame in the list is written to its corresponding Parquet file in the specified path.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_parquet(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
