% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{maskAggregators}
\alias{maskAggregators}
\alias{mediansByMask}
\alias{meansByMask}
\alias{sdsByMask}
\alias{mediansByWeight}
\alias{meansByWeight}
\alias{sdsByWeight}
\title{Multi-mask/weight based aggregators}
\usage{
mediansByMask(x, mask)

meansByMask(x, mask)

sdsByMask(x, mask)

mediansByWeight(x, weights)

meansByWeight(x, weights)

sdsByWeight(x, weights)
}
\arguments{
\item{x}{A vector to aggregate over with different masks or weights.}

\item{mask}{Logical matrix where each column represents a separate vector of masks 
to aggregate \code{x} with. Only values marked \code{TRUE} are included in the aggregation.}

\item{weights}{Integer matrix where each column represents frequency weights 
to weight the aggregation by.}
}
\value{
a vector with each value representing an aggregate of the same single input vector 
but with different masks or frequency weights applied.
}
\description{
Methods to aggregate the same vector with different masks or frequency weights.
Useful for fast bootstrapping or split-half scoring.
A single aggregate value of \code{x} is computed for each column of the mask or weight matrix.
}
\examples{

# Demonstration of mediansByMask()
x<-1:6
mask<-rbind(c(TRUE,FALSE,FALSE),
            c(TRUE,FALSE,FALSE),
            c(FALSE,TRUE,FALSE),
            c(FALSE,TRUE,FALSE),
            c(FALSE,FALSE,TRUE),
            c(FALSE,FALSE,TRUE))
mediansByMask(x,mask)

# Compute split-halves for a single 
# participant, stratified by stimulus
data(foodAAT)
currdata<-foodAAT[foodAAT$subjectid==3,]
currdata$stratfactor<-
  interaction(currdata$is_pull,
              currdata$is_target,
              currdata$stimid)
currdata<-currdata[order(currdata$stratfactor),]
groupsizes<-
  rle(as.character(currdata$stratfactor))$lengths
mysplits<-
  stratifiedItersplits(splits=1000,
                       groupsizes=groupsizes)

# Median for half 1
mediansByMask(currdata$RT,mysplits==1)
 
#How to use meansByMask()
meansByMask(x,mask)
sd(meansByMask(currdata$RT,mysplits==1))

# How to use sdsByMask() to compute
# mask-based D-scores
meansByMask(currdata$RT,mysplits==1) / 
  sdsByMask(currdata$RT,mysplits==1)

# Compute the bootstrapped 
# standard error of a median
weights<-
  bootstrapWeights(size=nrow(currdata),
                   times=1000)
bootmeds<-mediansByWeight(currdata$RT,weights)
sd(bootmeds) # bootstrapped standard error

# Compute the bootstrapped 
# standard error of a mean
bootmeans<-meansByWeight(currdata$RT,weights)
sd(bootmeans) # bootstrapped standard error
# exact standard error for comparison
sd(currdata$RT)/sqrt(length(currdata$RT)) 

# Use sdsByWeight to compute bootstrapped D-scores
bootsds<-sdsByWeight(currdata$RT,weights)
# bootstrapped standard error of D-score
sd(bootmeans/bootsds)

}
\seealso{
\link{colMedians}, \link{colAggregators}, \link{generateSplits}
}
\author{
Sercan Kahveci
}
