% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_extension_distributions.R
\name{r_matrix}
\alias{r_matrix}
\title{Generate a random Matrix}
\usage{
r_matrix(
  engine,
  row_names = NULL,
  col_names = NULL,
  ...,
  nrow = default_n(row_names),
  ncol = default_n(col_names),
  .seed = NULL
)
}
\arguments{
\item{engine}{The rando function that will be used to generate the random numbers}

\item{col_names, row_names}{names to be assigned to the rows or columns. This is also used in
deciding the dimensions of the result.}

\item{...}{Unused}

\item{nrow, ncol}{dimensions of the matrix. The \code{\link[=default_n]{default_n()}} function will provide
a default value within context.}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A matrix with \code{nrow} rows and \code{ncol} columns an a type as
decided by the function passed to \code{engine}.
}
\description{
Generate a random matrix, given a rando function and it's
dimensions. By default, this will generate a square matrix.
}
\examples{
set_n(5)

r_matrix(r_norm)


r_matrix(r_unif,min=1,max=2)


r_matrix(r_norm,mean=10,sd=2,ncol=2)


}
