% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{null_switch}
\alias{null_switch}
\title{Evaluate Expressions until not NULL}
\usage{
null_switch(...)
}
\arguments{
\item{...}{expressions to try to evaluate}
}
\value{
The result of evaluating one of the expressions. Will only be
\code{NULL} if they \emph{all} evaluated to \code{NULL}
}
\description{
Evaluates expressions until one that is not \code{NULL} is encountered
and returns that. Expressions after the first non-\code{NULL} result are not
evaluated. If all expressions are \code{NULL}, it will return \code{NULL}
}
\examples{
f <- function() {
  cat("Evaluating f\n")
  NULL
}
g <- function() {
  cat("Evaluating g\n")
  2
}

null_switch(NULL, f(), g())
null_switch(NULL, g(), f())
null_switch(f(), f(), f())
}
