% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{export_data_to_csv}
\alias{export_data_to_csv}
\title{Export Data to CSV Function}
\usage{
export_data_to_csv(nc_file, output_dir)
}
\arguments{
\item{nc_file}{Character. Path to the NetCDF file.}

\item{output_dir}{Character. Output directory where CSV files will be saved.}
}
\value{
None. CSV files are saved to the specified output directory.
}
\description{
Exports data from a NetCDF file to CSV files, one for each latitude and longitude point, including only points where data is present.
This function utilizes a Python script to perform the data processing.
}
\details{
The function calls a Python script using the `reticulate` package to process the NetCDF file.
The Python script `data_processing.py` should be located in the `python` directory of the `rIACI` package.
Only grid points with available data are exported to CSV files.
Each CSV file corresponds to a specific latitude and longitude point.
}
\examples{
\dontrun{
# Example usage of export_data_to_csv
netcdf_file <- "/path/to/processed_data.nc"
csv_output_directory <- "/path/to/csv_output"
export_data_to_csv(nc_file = netcdf_file, output_dir = csv_output_directory)
}
}
