% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{get_eigspace.spectral}
\alias{get_eigspace.spectral}
\title{Extract an Eigenspace from a Hermitian Matrix}
\usage{
\method{get_eigspace}{spectral}(object, id, ...)
}
\arguments{
\item{object}{an instance of class \code{spectral}.}

\item{id}{index for the desired eigenspace according to the ordered (decreasing) spectra.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix whose columns form the orthonormal eigenbasis.

If \code{s <- spectral(A)} and \code{V <- s$eigvectors}, then the extracted eigenspace
\eqn{V_{id}} is some submatrix \verb{V[, _]}.
}
\description{
Get the eigenbasis associated with an eigenvalue based on the representation
of a Hermitian Matrix given by class \code{spectral}.
}
\examples{
# Spectra is {2, -1} with multiplicities one and two respectively.
decomp <- spectral(matrix(c(0,1,1,1,0,1,1,1,0), nrow=3))

# Returns the two orthonormal eigenvectors corresponding to the eigenvalue -1.
get_eigspace(decomp, id=2)

# Returns the eigenvector corresponding to the eigenvalue 2.
get_eigspace(decomp, id=1)

}
\seealso{
\code{\link[=spectral]{spectral()}}, \code{\link[=get_eigspace]{get_eigspace()}}
}
