% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_baseline.R
\name{create_baseline_object}
\alias{create_baseline_object}
\title{Create Baseline Data Simulation Object}
\usage{
create_baseline_object(
  n_trt_int,
  n_ctrl_int,
  n_ctrl_ext,
  covariates,
  transformations
)
}
\arguments{
\item{n_trt_int}{Number of internal treated patients}

\item{n_ctrl_int}{Number of internal control patients}

\item{n_ctrl_ext}{Number of external control patients}

\item{covariates}{List of correlated covariates objects, see \code{\link[=baseline_covariates]{baseline_covariates()}}}

\item{transformations}{List of named transformation functions.}
}
\value{
A \link[=BaselineObject-class]{BaselineObject}
}
\description{
Create Baseline Data Simulation Object
}
\details{
Transformation functions are evaluated in order and create or overwrite a column
in the data.frame with that name. The function should take a \code{data.frame} (specifically
a \code{BaselineDataFrame} object from \code{generate(BaselineObject)}) and return a vector with
length identical to the total number of patients.
The \verb{@BaselineObject} slot may be accessed directly or with \code{\link[=get_quantiles]{get_quantiles()}} to
create transformations. See \code{\link[=binary_cutoff]{binary_cutoff()}}
}
\examples{
bl_no_covs <- create_baseline_object(
  n_trt_int = 100,
  n_ctrl_int = 50,
  n_ctrl_ext = 100
)


bl_biomarkers <- create_baseline_object(
  n_trt_int = 100,
  n_ctrl_int = 50,
  n_ctrl_ext = 100,
  covariates = baseline_covariates(
    c("b1", "b2", "b3"),
    means_int = c(0, 0, 0),
    covariance_int = covariance_matrix(c(1, 1, 1), c(.8, .3, .8))
  ),
  transformations = list(
    exp_b1 = function(data) exp(data$b1),
    b2 = binary_cutoff("b2", int_cutoff = 0.7, ext_cutoff = 0.5)
  )
)

}
