% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data_matrix_has_columns.R
\name{check_data_matrix_has_columns}
\alias{check_data_matrix_has_columns}
\title{Check Data Matrix for Required Columns}
\usage{
check_data_matrix_has_columns(object)
}
\arguments{
\item{object}{\code{Analysis}. Object to check.}
}
\value{
\code{stop()} if some columns are missing.
}
\description{
Check that an \code{Analysis} object's \code{data_matrix} has all the required variables.
}
\examples{
anls <- create_analysis_obj(
  data_matrix = example_matrix,
  covariates = add_covariates(
    covariates = c("cov1", "cov2"),
    priors = prior_normal(0, 1000)
  ),
  outcome = outcome_surv_exponential(
    "time",
    "cnsr",
    baseline_prior = prior_normal(0, 1000)
  ),
  borrowing = borrowing_hierarchical_commensurate(
    "ext",
    prior_exponential(.001)
  ),
  treatment = treatment_details(
    "trt",
    prior_normal(0, 1000)
  )
)

check_data_matrix_has_columns(anls)

}
