% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{get.creator}
\alias{get.creator}
\alias{get.users}
\title{Get creators and users of data}
\usage{
get.creator(adj.graph, data.node.id)

get.users(adj.graph, data.node.id)
}
\arguments{
\item{adj.graph}{the adjacency matrix}

\item{data.node.id}{the id of the data node.}
}
\value{
the id of the procedure node that created the specified data node.  
  Returns NULL if there is no node with the given id, the id is not for 
  a data node, or the data node does not have a creator.  The last case
  can occur, for example, if the data node represents an input file.

the id of the procedure node that created the specified data node.  
  Returns NULL if there is no node with the given id, the id is not for 
  a data node, or the data node does not have any users.  The last case
  can occur, for example, if the data node represents an output file.
}
\description{
get.creator finds the node that creates the given data node

A data node can represent a variable or a file.  The users
of the data node will be procedure nodes representing the statment
that used the variable in an expression or read from the file.
}
\details{
A data node can represent a variable, a file, a plot, or a warning or error.  The creator
of the data node will be a procedure node representing the statment
that assigned the variable, wrote to the file, created the plot, or 
resulted in the error or warning.
}
\examples{
adj.graph <- create.graph(system.file("testdata", "basic.json", package = "provGraphR"))
get.creator (adj.graph, "d1")

get.users (adj.graph, "d1")

}
\seealso{
\code{\link{create.graph}}

\code{\link{create.graph}}
}
