% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDiffPlotColor.R
\name{makeDiffPlotColor}
\alias{makeDiffPlotColor}
\title{Same as function makeDiffPlot, but add information by using colors.}
\usage{
makeDiffPlotColor(xdc = NULL, idCol = NULL, colorCol = NULL)
}
\arguments{
\item{xdc}{A data.frame with exactly three columns, one of the columns must be the identifier of all individuals, another column must be the differences between the measured and the predicted outcome values, and the third column must be the absolute differences between the bins of the measured and the predicted outcome.}

\item{idCol}{A single integer that denotes which of the columns of the data.frame contains the identifier of the individuals.}

\item{colorCol}{A single integer that denotes which of the columns of the data.frame contains the absolute differences between the bins of the measured and the predicted outcome.}
}
\value{
a list with the plot that shows the differences between the measured and predicted outcome for all individuals, using colorized points that express the differences in terms of number of bins.
}
\description{
Does the same as makeDiffPlot. However, additionally the difference between bins are added by using colors.
}
\details{
Recommendation: Use some of the ggplot2 options to enhance the plot, e.g., using the function facet_wrap (for an example, see vignette \strong{predictMe Why and how to?, headline 'Function makeDiffPlotColor (to go into more detail)'}).
}
\examples{
# Simulate data set with continuous outcome (use all default values)
dfContinuous <- quickSim()
# Use multiple linear regression as algorithm to predict the outcome.
lmRes <- lm(y~x1+x2,data=dfContinuous)
# Extract measured outcome and the predicted outcome (fitted values)
# from the regression output, put both in a data.frame.
lmDf <- data.frame(measOutcome=dfContinuous$y,
                   fitted=lmRes$fitted.values)
# Apply function binContinuous.
x100c <- binContinuous(x=lmDf, measColumn = 1, binWidth = 20)
# Apply function makeDiffPlotColor, using columns 5 and 6 from x100c[["xTrans"]]
# The second of columns 5 and 6 contains the identifiers of the individuals.
dpc <- makeDiffPlotColor(x100c[["xTrans"]][,5:7], idCol = 2, colorCol=3)
# dpc is the plot that shows the individual differences, in colorized form.
# makeDiffPlotColor works the same way if binBinary had be used instead of
# binContinuous.
}
\references{
\insertRef{ggplot2Wickham}{predictMe}
}
\author{
Marcel Miché
}
