% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release.R
\name{release_gh}
\alias{release_gh}
\title{Create a new release on GitHub}
\usage{
release_gh(bump = "dev", is_cran = bump != "dev")
}
\arguments{
\item{bump}{The bump increment, either "dev", "patch", "minor" or "major".}

\item{is_cran}{Is this release a CRAN release?}
}
\description{
This must be done \strong{before} a CRAN release.
}
\details{
This function does the following:
\itemize{
\item bump description.
\item update default config in inst/
\item commit
\item git tag
\item run \code{inst/hooks/local/consistent-release-tag.R} hook with --release-mode (passing args to hooks
not possible interactively, hence we run in advance).
\item commit and push with skipping \code{inst/hooks/local/consistent-release-tag.R}.
\item autoupdate own config file
\item bump description with dev
\item commit and push DESCRIPTION and .pre-commit-config.yaml
}
}
\section{CRAN release}{

If \code{is_cran} is \code{TRUE}, the workflow is changed slightly:
\itemize{
\item push to release branch, not main.
\item doesn't run \code{\link[=release_complete]{release_complete()}}. This must be done manually after accepted
on CRAN.
}
}

\keyword{internal}
