% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_pkg}
\alias{build_pkg}
\title{Build a package tar.gz}
\usage{
build_pkg(pkg_path = ".", img_path = NULL, ...)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}

\item{...}{Additional optional arguments passed to \link[pkgbuild:build]{pkgbuild::build}.}
}
\value{
Invisibly returns a list of package info returned by \link{pkg_info}, tar.gz source and destination file paths.
}
\description{
Builds a package source tar.gz using \link[pkgbuild:build]{pkgbuild::build} and moves it into a user-specified location (default \verb{docker/}).
}
\examples{
\dontrun{
# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Build the example package from tempdir()
build_pkg(pkg = file.path(tempdir(), "hellow"))
}
}
