% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{add_dockerfile}
\alias{add_dockerfile}
\title{Add a Dockerfile to the docker directory}
\usage{
add_dockerfile(
  pkg_path = ".",
  img_path = NULL,
  use_renv = TRUE,
  use_case = "default",
  base_image = NULL,
  repos = NULL
)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}

\item{use_renv}{Logical; use renv? Defaults to \code{TRUE}. If \code{FALSE}, package dependencies are scraped from the \code{DESCRIPTION} file and the most recent versions will be installed in the image.}

\item{use_case}{Name of the use case. Defaults to \code{"default"}, which only uses the base boilerplate. See \code{vignette("use-cases", package="pracpac")} for other use cases (e.g., \code{shiny}, \code{rstudio}, \code{pipeline}).}

\item{base_image}{Name of the base image to start \code{FROM}. Default is \code{NULL} and the base image will be derived based on \code{use_case.} Optionally override this by setting the name of the base image (including tag if desired).}

\item{repos}{Option to override the repos used for installing packages with \code{renv} by passing name of repository. Only used if \code{use_renv = TRUE}. Default is \code{NULL} meaning that the repos specified in \code{renv} lockfile will remain as-is and not be overridden.}
}
\value{
Invisibly returns a list of package info returned by \link{pkg_info}. Primarily called for side-effect to create Dockerfile.
}
\description{
Adds a Dockerfile to the docker directory created by \link{create_docker_dir}.
Allows for specification of several preset use cases, whether or not use use
renv to manage dependencies, and optional overriding the base image.
}
\details{
This function is run as part of \link{use_docker} but can be used on its own.

See \code{vignette("use-cases", package="pracpac")} for details on use cases.
}
\examples{
\dontrun{

# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Default: FROM rocker/r-ver:latest with no additional template
# By default add_dockerfile requires you either to specify use_renv = FALSE
# Or run renv_deps() prior to add_dockerfile()
# The use_docker() wrapper runs these sequentially, and is recommended for most usage
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), use_renv = FALSE)
# Specify tidyverse base image
renv_deps(pkg_path = file.path(tempdir(), "hellow"))
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), base_image="rocker/tidyverse:4.2.2")
# Specify different default repo
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), repos="https://cran.wustl.edu/")
# RStudio template
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), use_case="rstudio")
# Shiny template
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), use_case = "shiny")
# Pipeline template
add_dockerfile(pkg_path = file.path(tempdir(), "hellow"), use_case="pipeline")
}
}
