% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{tauInitial}
\alias{tauInitial}
\title{List of initial values for \eqn{\tau}}
\usage{
tauInitial(data, n, Q, d_part, n_perturb, perc_perturb, n_random, directed)
}
\arguments{
\item{data}{Data : only needs the \eqn{N_{ijk}} field of data}

\item{n}{Total number of nodes}

\item{Q}{Total number of groups}

\item{d_part}{Maximal level for finest partitions of time interval [0,T], used for kmeans initializations.
\itemize{
  \item Algorithm takes partition up to depth \eqn{2^d} with \eqn{d=1,...,d_{part}}
  \item Explore partitions \eqn{[0,T], [0,T/2], [T/2,T], ... [0,T/2^d], ...[(2^d-1)T/2^d,T]}
  \item Total number of partitions \eqn{npart= 2^{(d_part +1)} - 1}
}}

\item{n_perturb}{Number of different perturbations on k-means result}

\item{perc_perturb}{Percentage of labels that are to be perturbed (= randomly switched)}

\item{n_random}{Number of completely random initial points. If not zero there will be n_random taus uniformly sampled in the initialization.}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
List of matrixes of initial values for \eqn{\tau}
}
\description{
Same function whatever directed or undirected case
}
\details{
The (maximal) total number of initializations is \eqn{d_{part}*(1+n_{perturb}) + n_{random}}
}
\keyword{internal}
