% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{pbi_schema_relation_create}
\alias{pbi_schema_relation_create}
\title{Define table relationship}
\usage{
pbi_schema_relation_create(
  from_table = NULL,
  from_column = NULL,
  to_table = NULL,
  to_column = from_column,
  direction = c("OneDirection", "BothDirections", "Automatic"),
  name = paste0(from_table, to_table, from_column)
)
}
\arguments{
\item{from_table}{The name of the foreign key table}

\item{from_column}{The name of the foreign key column}

\item{to_table}{The name of the primary key table}

\item{to_column}{The name of the primary key column. Defaults to from_column}

\item{direction}{The filter direction of the relationship. Defaults to
'OneDirection'}

\item{name}{The relationship name and identifier. Defaults to a concatenation
of from_table, to_table and from_column}
}
\value{
A data.table
}
\description{
Defines a relationship between tables in a Power BI push dataset. To add this
definition to a Power BI dataset schema, use pbi_schema_add_relations().
}
\examples{
# An example
}
