% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push.R
\name{pbi_push_rows}
\alias{pbi_push_rows}
\title{Push rows to a dataset table}
\usage{
pbi_push_rows(dt, group_id, dataset_id, table_name, overwrite = FALSE)
}
\arguments{
\item{dt}{A data frame with rows to be added to the specified Power BI table
(table_name). The columns and data types must match the specified table.}

\item{group_id}{The ID of the destination Power BI workspace.}

\item{dataset_id}{The ID of the destination Power BI dataset.}

\item{table_name}{The name of the destination Power BI table.}

\item{overwrite}{If TRUE, existing rows will be deleted prior to adding new
rows. If FALSE, the new rows will be appended to the existing rows.}
}
\value{
A dataset with tables and optionally defined relationships will be
  created in the specified Power BI workspace.
}
\description{
Adds new data rows to the specified table within the specified dataset
from the specified Power BI workspace. Only applicable to push datasets.
}
\details{
The Power BI REST has a limit of 10K rows per POST rows request. This limit
is handled by splitting the data frame into chunks of 10K rows each and
pushing these chunks one at a time. However, you should manually observe the
other limitations of the API. See
\url{https://docs.microsoft.com/en-au/rest/api/power-bi/} for more details.
}
\examples{

\dontrun{

group_id <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
dataset_id <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"

pbi_push_rows(group_id, dataset_id, "My table")
}
}
