% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{pbi_dataset_refresh}
\alias{pbi_dataset_refresh}
\title{Refresh dataset}
\usage{
pbi_dataset_refresh(group_id, dataset_id)
}
\arguments{
\item{group_id}{The ID of the workspace.}

\item{dataset_id}{The ID of the dataset.}
}
\value{
If successful, the refresh request ID is returned.
}
\description{
Triggers a refresh for the specified dataset from the specified workspace.
}
\examples{

\dontrun{

group_id <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
dataset_id <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"

pbi_dataset_refresh(group_id, dataset_id)
#> A refresh of dataset xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx was triggered.
#>
#> To check status, use pbi_dataset_refresh_hist() and the request ID returned
#> by this function.
#> [1] "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
}
}
\seealso{
\link{pbi_dataset_refresh_hist}
}
