% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-utils.R
\name{get_design_matrix}
\alias{get_design_matrix}
\title{\code{get_design_matrix} gets design matrix for gaussian, binomial, and poisson models}
\usage{
get_design_matrix(formula, data, random.effects, na.action = NULL)
}
\arguments{
\item{formula}{A two-sided linear formula object describing the
mixed effects of the model.

To specify that a random term should have phylogenetic covariance matrix along
with non-phylogenetic one, add \code{__} (two underscores) at the end of the group variable;
e.g., \code{+ (1 | sp__)} will construct two random terms,
one with phylogenetic covariance matrix and another with non-phylogenetic (identity) matrix.
In contrast, \code{__} in the nested terms (below) will only create a phylogenetic covariance matrix.
Nested random terms have the general form \code{(1|sp__@site__)} which represents
phylogenetically related species nested within correlated sites.
This form can be used for bipartite questions. For example, species could be
phylogenetically related pollinators and sites could be phylogenetically related plants, leading to
the random effect \code{(1|insects__@plants__)}. If more than one phylogeny is used, remember to add
all to the argument \code{cov_ranef = list(insects = insect_phylo, plants = plant_phylo)}. Phylogenetic correlations can
be dropped by removing the \code{__} underscores. Thus, the form \code{(1|sp@site__)} excludes the phylogenetic
correlations among species, while the form \code{(1|sp__@site)} excludes the correlations among sites.

Note that correlated random terms are not allowed. For example,
\code{(x|g)} will be the same as \code{(0 + x|g)} in the \code{lme4::lmer} syntax. However,
\code{(x1 + x2|g)} won't work, so instead use  \code{(x1|g) + (x2|g)}.}

\item{data}{A \code{\link{data.frame}} containing the variables named in formula.}

\item{random.effects}{Optional pre-build list of random effects. If \code{NULL} (the default),
the function \code{\link{prep_dat_pglmm}} will prepare the random effects for you from the information
in \code{formula}, \code{data}, and \code{cov_ranef}. \code{random.effect} allows a list of
pre-generated random effects terms to increase flexibility; for example, this makes it
possible to construct models with both phylogenetic correlation and spatio-temporal autocorrelation.
In preparing \code{random.effect}, make sure that the orders of rows and columns of
covariance matrices in the list are the same as their corresponding group variables
in the data. Also, this should be \emph{a list of lists}, e.g.
\code{random.effects = list(re1 = list(matrix_a), re2 = list(1, sp = sp, covar = Vsp))}.}

\item{na.action}{What to do with NAs?}
}
\value{
A list of design matrices.
}
\description{
\code{get_design_matrix} gets design matrix for gaussian, binomial, and poisson models
}
