% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reposition}
\alias{reposition}
\title{Reset dendrogram height attributes.}
\usage{
reposition(x, shift = "reset")
}
\arguments{
\item{x}{an object of class \code{"dendrogram"}.}

\item{shift}{either the character string "reset" (shift the graph so that
the height of the farthest leaf from the root is zero), or a numeric value
giving the amount to shift the graph along the primary axis.}
}
\value{
Returns an object of class \code{"dendrogram"}.
}
\description{
\code{reposition} is a helper function used for manually creating
  \code{"dendrogram"} objects from nested lists. The function
  recursively reassigns the 'height' attributes at each node by
  a given constant.
}
\examples{
  x <- read.dendrogram(text = "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);")
  plot(x, horiz = TRUE)
  x <- reposition(x)
  plot(x, horiz = TRUE)
}
\author{
Shaun Wilkinson
}
