% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRep4.R
\name{pRep4}
\alias{pRep4}
\title{p-rep designs with unequal block sizes}
\usage{
pRep4(v, m, s, randomized_layout = FALSE)
}
\arguments{
\item{v}{Total number of treatments (v = 2ms*(s-1))}

\item{m}{Positive integer (m>=1)}

\item{s}{Positive integer (s>=3)}

\item{randomized_layout}{TRUE or FALSE. By default it is FALSE.}
}
\value{
This function calculates design parameters (v, b1, b2, r, k1, k2),
average variance factors, and canonical efficiency factors of generated
designs.
}
\description{
The first step of this function involves generating a higher
associate PBIB (partially balanced incomplete block) design consisting of two
sets of blocks. Subsequently, by creating various combinations of these two
sets of blocks, it generates multiple p-rep designs in different environments
with unequal block sizes.
}
\examples{
\dontrun{
library(pRepDesigns)
pRep4(48, 2, 4)}
}
