% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassTrtSelOptThresh.R, R/ClassDiagOptThresh.R
\docType{methods}
\name{summary-methods}
\alias{summary-methods}
\alias{summary.trtSelOptThresh}
\alias{summary,trtSelOptThresh-method}
\alias{summary.diagOptThresh}
\alias{summary,diagOptThresh-method}
\title{An S4 method that summarizes the results of a \code{trtSelOpthThresh} or a \code{diagOpthThresh} object.}
\usage{
\S4method{summary}{trtSelOptThresh}(object, alpha = 0.05,
  method = "median")

\S4method{summary}{diagOptThresh}(object, alpha = 0.05,
  method = "median")
}
\arguments{
\item{object}{a \code{trtSelOptThresh} S4 class object for which a summary is desired.}

\item{alpha}{alpha parameter for the confidence level required.}

\item{method}{which method to use: median, mean or mode (median is the default).}
}
\value{
This function returns an object of class 'summaryTrtSelOptThresh'.

This function returns an object of class 'summaryDiagOptThresh'.
}
\description{
An S4 method that summarizes the results of a \code{trtSelOpthThresh} or a \code{diagOpthThresh} object.
}
\details{
This function presents the results stocked in a \code{trtSelOpthThresh} object, or in a \code{diagOpthThresh} object. For a \code{trtSelOpthThresh} object it prints:
\itemize{
	\item The decision rule: is the reference treatment recommended for low values of the marker?
\item The median (default), mean, or mode risk of event occurrence in each treatment arm, and their credible interval.
\item Some summary statistics of the marker under study (min, max, quartiles and mean)
\item The optimal threshold estimate and its credible interval (percentile and highest posterior density).
\item The median (default), mean, or mode risk in each arm under the marker-based strategy.
\item The median (default), mean, or mode benefit estimate under each treatment arm.
\item The percentage of NA values returned during the optimal threshold estimation process.
}

For a \code{diagOpthThresh} object, it prints:
\itemize{
	\item The decision rule: is the reference treatment recommended for low values of the marker?
\item The median (default), mean, or mode risk of event occurrence in each treatment arm, and their credible interval.
\item Some summary statistics of the marker under study (min, max, quartiles and mean)
\item The optimal threshold estimate and its credible interval (percentile and highest posterior density).
\item The median (default), mean, or mode risk in each arm under the marker-based strategy.
\item The median (default), mean, or mode benefit estimate under each treatment arm.
\item The percentage of NA values returned during the optimal threshold estimation process.
}
}
\section{References }{

Blangero, Y, Rabilloud, M, Ecochard, R, and Subtil, F. A Bayesian method to estimate the optimal threshold of a marker used to select patients' treatment. \emph{Statistical Methods in Medical Research}. 2019.


Subtil, F, and Rabilloud. A Bayesian method to estimate the optimal threshold of a longitudinal biomarker. \emph{Biometrical Journal}. 2010.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}} for more details on how to estimate the optimal threshold of a treatment selection marker.

\code{\link[optimalThreshold]{diagThresh}} for more details on how to estimate the optimal threshold of a diagnostic marker.
}
