% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian.R
\docType{methods}
\name{hessian}
\alias{hessian}
\alias{hessian,normalDist-method}
\alias{hessian.normalDist}
\alias{hessian,logNormalDist-method}
\alias{hessian.logNormalDist}
\alias{hessian,gammaDist-method}
\alias{hessian.gammaDist}
\alias{hessian,studentDist-method}
\alias{hessian.studentDist}
\alias{hessian,logisticDist-method}
\alias{hessian.logisticDist}
\alias{hessian,compoundEvtRefDist-method}
\alias{hessian.compoundEvtRefDist}
\alias{hessian,compoundNoEvtRefDist-method}
\alias{hessian.compoundNoEvtRefDist}
\alias{hessian,compoundEvtInnovDist-method}
\alias{hessian.compoundEvtInnovDist}
\alias{hessian,compoundNoEvtInnovDist-method}
\alias{hessian.compoundNoEvtInnovDist}
\title{Second derivative of the cumulative distribution function of a specified distribution}
\usage{
hessian(object)

\S4method{hessian}{normalDist}(object)

\S4method{hessian}{logNormalDist}(object)

\S4method{hessian}{gammaDist}(object)

\S4method{hessian}{studentDist}(object)

\S4method{hessian}{logisticDist}(object)

\S4method{hessian}{compoundEvtRefDist}(object)

\S4method{hessian}{compoundNoEvtRefDist}(object)

\S4method{hessian}{compoundEvtInnovDist}(object)

\S4method{hessian}{compoundNoEvtInnovDist}(object)
}
\arguments{
\item{object}{A distribution object.}
}
\value{
Returns the second derivative of the cumulative distribution function of the specified distribution.
}
\description{
The \code{hessian} function returns the second derivative of the cumulative distribution function relative to the S4 object passed in its argument. See details to know on what kind of S4 objects this function could be applied.
}
\details{
This method can be applied to the S4 distribution objects that are supported in the \code{optimalThreshold} package: \code{normalDist}, \code{logNormalDist}, \code{gammaDist}, \code{studentDist}, \code{logisticDist}, and \code{userDefinedDist}. These methods are applied internally, and you have no need to use it outside of the main functions \code{trtSelThresh} and \code{diagThresh}. 
\itemize{
\item Normal distribution: the \code{hessian} method applied to a \code{normalDist} object is simply the second derivative of the cumulative distribution function of a normal distribution, with \code{mu}=\eqn{\mu} and \code{sd}=\eqn{\sigma}, and expressed as: 
\deqn{f'(x)=((\mu-x)/\sigma^2)*f(x)}
\item Log-normal distribution: the \code{hessian} method applied to a \code{logNormalDist} object is simply the second derivative of the cumulative distribution function of a log-normal distribution, with \code{mu}=\eqn{\mu} and \code{sd}=\eqn{\sigma}, and expressed as:
\deqn{f'(x)=(((\mu-\log(x))/(x*\sigma^2))-1/x)*f(x)}
\item Gamma distribution: the \code{hessian} method applied to a \code{gammaDist} object is simply the second derivative of the cumulative distribution function of a gamma distribution, with \code{shape}=\eqn{\alpha} and \code{scale}=\eqn{\beta}, and expressed as:
\deqn{f'(x)=((\alpha-1)/x-1/\beta)*f(x)}
\item Scaled t distribution: the \code{hessian} method applied to a \code{studentDist} object is simply the second derivative of the cumulative distribution function of a t scaled distribution, with \code{df}=n, \code{mu}=\eqn{\mu} and \code{sd}=\eqn{\sigma}, and expressed as:
\deqn{f'(x)=(-(n+1))*((x-\mu)/(\sigma^2*(n+((x-\mu)/\sigma)^2)))*f(x)}
\item Logistic distribution: the \code{hessian} method applied to a \code{logisticDist} object is simply the second derivative of the cumulative distribution function of a logistic distribution, with \code{location}=\eqn{\mu}, and \code{scale}=\eqn{\sigma}, and expressed as:
\deqn{f'(x)=((\exp(-(x-\mu)/\sigma)^2-1)/(\sigma*(1+\exp(-(x-\mu)/\sigma))^2))*f(x)}
\item User-defined distribution: the \code{hessin} method applied to a \code{userDefinedDist} object is simply the hessian function provided by the user when fitting a user-defined distribution with the \code{fit} function.
}
The S4 objects \code{compoundEvtRefDist}, \code{compoundNoEvtRefDist}, \code{compoundEvtInnovDist}, and \code{compoundNoEvtInnovDist} are created internally. The \code{hessian} function applied to these objects is defined dynamically depending on what types of distribution are fitted. The definition of the \code{hessian} function relies on the expression of the randomization constraint of a clinical trial that enforces the distribution of the marker in each treatment arm to be identical (see References for more details).
}
\section{References}{

Blangero, Y, Rabilloud, M, Ecochard, R, and Subtil, F. A Bayesian method to estimate the optimal threshold of a marker used to select patients' treatment. \emph{Statistical Methods in Medical Research}. 2019.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}}, \code{\link[optimalThreshold]{fit}}
}
