% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFitStudentDist.R
\docType{class}
\name{fitStudentDist-class}
\alias{fitStudentDist-class}
\alias{fitStudentDist}
\title{An S4 class to fit a Student distribution on a vector of marker values.}
\description{
This class allows to fit a t distribution on the marker values \code{x}.
}
\details{
This class is automatically created when the user applies the \code{fit} function with the argument \code{distr="t"}. You never have to create manually this class, it is created internally.
}
\section{Slots}{

\describe{
\item{\code{x}}{This slot takes in argument the marker values. Numeric argument.}

\item{\code{n}}{Length of x vector (including NA values). Numeric argument.}

\item{\code{ini}}{This slot is a list of initial values passed to the MCMC algorithm. List argument.}

\item{\code{thin}}{This slot is a strictly positive integer value that specifies the 'thin' applied to the MCMC algorithm.}

\item{\code{burnin}}{This slot is a positive integer value that specifies the length of the burnin period in the MCMC algorithm.}

\item{\code{model}}{This slot is a character string that specifies the model passed to the JAGS software to perform the MCMC algorithm.}

\item{\code{mcmc}}{This slot allows the main function to know whether an MCMC algorithm must be performed to sample the distribution parameters from their posterior distribution.}
}}

\seealso{
\code{\link[optimalThreshold]{fit}} for more details on how to fit a t distribution.
}
