% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_openapp_data.R
\name{get_openapp_data}
\alias{get_openapp_data}
\title{Get data from OpenAppBuilder}
\usage{
get_openapp_data(
  site = get_app_connection(),
  name = c("app_users", "app_notification_interaction"),
  filter = FALSE,
  filter_variable = NULL,
  filter_variable_value = NULL,
  qry = NULL
)
}
\arguments{
\item{site}{The name of the PostgreSQL database connection (using \code{DBI::dbConnect} or \code{set_app_connection()}).}

\item{name}{A character string specifying the table to retrieve data from. Default is \code{"app_users"}, but \code{"app_notification_interaction"} can also be specified. This parameter is ignored if \code{qry} is provided.}

\item{filter}{A logical value indicating whether to filter the data based on a specific column (defaults to \code{FALSE}).}

\item{filter_variable}{A character string representing the name of the column to filter if \code{filter == TRUE}.}

\item{filter_variable_value}{A character string or vector representing the value(s) of the \code{filter_variable} column to filter if \code{filter == TRUE}.}

\item{qry}{An optional character string containing an SQL query. If provided, this query overrides the \code{name} parameter and allows for custom SQL to be executed.}
}
\value{
A data frame containing the retrieved data from the specified PostgreSQL table or the result of the executed SQL query.
}
\description{
Retrieves data from OpenAppBuilder by querying the specified PostgreSQL database. The function can either retrieve all data from a specific table (e.g., \code{app_users} or \code{app_notification_interaction}) or execute a custom SQL query provided by the user.
}
\examples{
# First we need to set an app connection
set_app_connection(
  dbname = "vmc",
  host = "apps-server.idems.international",
  port = 5432,
  user = "vmc",
  password = "LSQkyYg5KzL747"
)

# Retrieve all data from the 'app_users' table
data_all_users <- get_openapp_data(name = "app_users")

# Retrieve filtered data from the 'app_users' table where 'app_user_id' is
# a specified ID.
valid_ids <- c("3e68fcda-d4cd-400e-8b12-6ddfabced348",
               "223925c7-443a-411c-aa2a-a394f991dd52")
data_filtered_users <- get_openapp_data(
  name = "app_users",
  filter = TRUE,
  filter_variable = "app_user_id",
  filter_variable_value = valid_ids
)

# Retrieve data using a custom SQL query
custom_query_data <- get_openapp_data(
  qry = "SELECT * FROM app_users WHERE app_version = '0.16.33'"
)
}
