% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filterStrata}
\alias{filterStrata}
\title{Filter the strata_name-strata_level pair in a summarised_result}
\usage{
filterStrata(result, ...)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{...}{Expressions that return a logical value (\code{strataColumns()} are
used to evaluate the expression), and are defined in terms of the variables
in .data. If multiple expressions are included, they are combined with the &
operator. Only rows for which all conditions evaluate to TRUE are kept.}
}
\value{
A \verb{<summarised_result>} object with only the rows that fulfill the
required specified strata.
}
\description{
Filter the strata_name-strata_level pair in a summarised_result
}
\examples{
library(dplyr)
library(omopgenerics)

x <- tibble(
  "result_id" = 1L,
  "cdm_name" = "eunomia",
  "group_name" = "cohort_name",
  "group_level" = "my_cohort",
  "strata_name" = c("sex", "sex &&& age_group", "sex &&& year"),
  "strata_level" = c("Female", "Male &&& <40", "Female &&& 2010"),
  "variable_name" = "number subjects",
  "variable_level" = NA_character_,
  "estimate_name" = "count",
  "estimate_type" = "integer",
  "estimate_value" = c("100", "44", "14"),
  "additional_name" = "overall",
  "additional_level" = "overall"
) |>
  newSummarisedResult()

x |>
  filterStrata(sex == "Female")

}
