% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm2.R
\name{dtmwrappers}
\alias{dtm2}
\alias{dtmwrappers}
\alias{tdm2}
\title{Wrappers to DocumentTermMatrix and DocumentTermMatrix to use n-gram tokenizaion}
\usage{
dtm2(x, char = FALSE, ngmin = 1, ngmax = 2, rmEOL = TRUE, ...)

tdm2(x, char = FALSE, ngmin = 1, ngmax = 2, rmEOL = TRUE, ...)
}
\arguments{
\item{x}{character vector, \code{Source} or \code{Corpus} to be converted}

\item{char}{logical, using character n-gram. char = FALSE denotes word n-gram.}

\item{ngmin}{integer, minimun order of n-gram}

\item{ngmax}{integer, maximun order of n-gram}

\item{rmEOL}{logical, remove ngrams wih EOL character}

\item{...}{Additional options for \code{DocumentTermMatrix} or \code{DocumentTermMatrix}}
}
\value{
\code{DocumentTermMatrix} or \code{DocumentTermMatrix}
}
\description{
Wrappers to \code{DocumentTermMatrix} and \code{DocumentTermMatrix} to use n-gram tokenization provided by \code{ngramrr}.
}
\examples{
nirvana <- c("hello hello hello how low", "hello hello hello how low",
"hello hello hello how low", "hello hello hello",
"with the lights out", "it's less dangerous", "here we are now", "entertain us",
"i feel stupid", "and contagious", "here we are now", "entertain us",
"a mulatto", "an albino", "a mosquito", "my libido", "yeah", "hey yay")
dtm2(nirvana, ngmax = 3, removePunctuation = TRUE)
}
\seealso{
\code{ngramrr}, \code{\link[tm]{DocumentTermMatrix}}, \code{\link[tm]{TermDocumentMatrix}}
}

