% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-commutative.R, R/na.max.R, R/na.mean.R,
%   R/na.median.R, R/na.mode.R
\name{impute-commutative}
\alias{impute-commutative}
\alias{na.max}
\alias{na.min}
\alias{na.mean}
\alias{na.median}
\alias{na.quantile}
\alias{na.mode}
\alias{na.most_freq}
\title{Imputation by Cummutative Functions

Impute using replacement values calculated from a univariate, cummuative
function.}
\usage{
na.max(.x, ...)

na.min(.x, ...)

na.mean(.x, ...)

na.median(.x, ...)

na.quantile(.x, ...)

na.mode(.x, ...)

na.most_freq(.x, ...)
}
\arguments{
\item{.x}{vector in which \code{NA} values are to be replaced. The ordering of \code{x}
does not matter.}

\item{...}{additional arguments passed to lower-level summary functions.}
}
\value{
A vector of \code{class(x)} and \code{length(x)} in which missing values (NA) have
been replaced the result of a function call: \deqn{ fun(x, ...) }
}
\description{
Imputation by Cummutative Functions

Impute using replacement values calculated from a univariate, cummuative
function.

\code{na.median} imputes with the median value of \code{x}. The median is only valid
for numeric or logical values.
}
\details{
This collection of functions calculates a replacement value using an
unvariate function where the order of values in \code{x} do not matter,
i.e. commutative.

\code{na.max} and \code{na.min} replace missing values (\code{NA}) with the maximum or
minimum \emph{of non-missing values \code{x}.}
( Internally: \code{base::max(..., na.rm=TRUE)} and \code{base::min(..., na.rm=TRUE)}.
\code{...} has no affect.

\code{na.mean} replaces \code{NA} values with the mean of \code{x}. Internally,
\code{mean(x, na.rm=TRUE, ... )} is used. If mean cannot be calculated (e.g. x
isn't numeric) then \code{x} is returned with a warning.

\code{na.quantile} imputes with a quantile. The quantile is specified by a
\code{probs} argument that is passed to \code{\link[stats:quantile]{stats::quantile()}}. If \code{probs} can be
a scalar value in which all values are replaced by that quantile or a vector
of \code{length(.x)} values which replaces the missing values of x with the
\code{probs}. The ability to provide a vector may be deprecated in the future.

\code{na.mode} replaces all \code{NA} with the most frequently occuring value. In
the event of ties, the value encounter first in \code{.x} is used.

\code{na.most_freq} is an alias for \code{na.mode}.
}
\examples{
  na.median( c(1,2,NA_real_,3) )
      
  na.quantile( c(1,2,NA_real_,3), prob=0.4 )

  na.mode( c(1,1,NA,4) )
  na.mode( c(1,1,4,4,NA) ) 

}
\seealso{
\itemize{
\item \code{\link[=na.replace]{na.replace()}} - used internally by these functions
\item \code{\link[=na.constant]{na.constant()}}
}

\itemize{
\item \code{\link[base:max]{base::max()}} and \code{\link[base:min]{base::min()}}
}

\code{\link[=median]{median()}}

\itemize{
\item \code{\link[=quantile]{quantile()}}
}
}
