% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{print.brmcoda}
\alias{print.brmcoda}
\title{Print a Summary for a fitted \code{brmsfit} model in a \code{brmcoda} object}
\usage{
\method{print}{brmcoda}(x, ...)
}
\arguments{
\item{x}{An object of class \code{brmcoda}.}

\item{...}{Other arguments passed to \code{summary.brmcoda}.}
}
\description{
Print a Summary for a fitted \code{brmsfit} model in a \code{brmcoda} object
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
  formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                     wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")

 print(m)
}}
}
\seealso{
\code{\link{summary.brmcoda}}
}
