% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePhi.R
\name{findGoodPoints}
\alias{findGoodPoints}
\title{Function to find good points for estimation of phi}
\usage{
findGoodPoints(
  data,
  maxPointsToUseInEstimate,
  phiInitialEstimate,
  windowSize,
  ...
)
}
\arguments{
\item{data}{An move object.}

\item{maxPointsToUseInEstimate}{The number of desired windows.}

\item{phiInitialEstimate}{The initial value used for the autocorrelation when calculating the wind speed for finding suitable windows.}

\item{windowSize}{An odd number providing the window size}

\item{...}{passed on to getWindEstimates}
}
\value{
a logical vector with the focal locations
}
\description{
The function tries to find non overlapping windows for phi optimization.
}
\examples{
data(storks)
which(findGoodPoints( storks[[2]],
windowSize = 29,  isSamplingRegular = 1,
isThermallingFunction = getDefaultIsThermallingFunction(360, 4),  maxPointsToUseInEstimate = 10,
phiInitialEstimate = 0  ))
}
