% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selected.R
\name{selected}
\alias{selected}
\title{Shows which variables were selected for each node of a network}
\usage{
selected(object, threshold = FALSE, mod = c("temporal", "between"))
}
\arguments{
\item{object}{Output from either \code{\link{fitNetwork}} or
\code{\link{mlGVAR}}}

\item{threshold}{Can be a numeric value between \code{0} and \code{1}, or
defaults to \code{.05} when set to \code{TRUE}}

\item{mod}{Only relevant to models fit with \code{\link{mlGVAR}}}
}
\value{
A table where the columns represent nodes, and the rows show which
variables were selected in predicting each node. For moderated networks,
the output is a list that separates main effects (\code{mods}) from
interaction effects (\code{ints}).
}
\description{
Provides a quick representation showing which variables were selected as
predictors of each node in a network, both for unmoderated and moderated
networks. Especially useful as a way to see which variables were selected in
a variable selection procedure, such as through the \code{\link{varSelect}}
and \code{\link{resample}} functions.
}
\details{
The \code{threshold} argument allows the user to set a threshold for
p-values, such that the output only reflects the predictors that are
significant at that threshold. This argument can be utilized whether or not a
variable selection procedure has been employed.
}
\examples{
\donttest{
fit1 <- fitNetwork(ggmDat)
selected(fit1)

fit2 <- mlGVAR(mlgvarDat, m = 'M', verbose = FALSE)
selected(fit2, threshold = TRUE, mod = 'temporal') # Can also set to 'between'

fit3 <- fitNetwork(gvarDat, moderators = 'M', type = 'varSelect', lags = 1)
selected(fit3)
}
}
\seealso{
\code{\link{fitNetwork}, \link{mlGVAR}}
}
