% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{plot.resample}
\alias{plot.resample}
\title{Plot method for output of resample function}
\usage{
\method{plot}{resample}(x, what = "network", ...)
}
\arguments{
\item{x}{Output from the \code{\link{resample}} function.}

\item{what}{Can be one of three options for all \code{\link{resample}}
outputs: \code{what = "network"} will plot the final network model selected
from resampling. \code{what = "bootstrap"} will run \code{\link{bootNet}}
based on the final model to create bootstrapped estimates of confidence
bands around each edge estimate. \code{what = "coefs"} will plot the
confidence intervals based on the model parameters in the final network.
Additionally, if the object was fit with \code{sampMethod = "stability"}, a
stability plot can be created with the \code{"stability"} option.
Otherwise, if \code{sampMethod = "bootstrap"} or \code{sampMethod =
  "split"}, a plot of the empirical distribution function of p-values can be
displayed with the \code{"pvals"} option.}

\item{...}{Additional arguments.}
}
\value{
Plots various aspects of output from the \code{\link{resample}}
function.
}
\description{
Allows one to plot results from the \code{\link{resample}} function based on
a few different options.
}
\details{
For the \code{what} argument, the options correspond with calls to the
following functions: \itemize{ \item{\code{"network": \link{plotNet}}}
\item{\code{"bootstrap": \link{plotBoot}}} \item{\code{"coefs":
\link{plotCoefs}}} \item{\code{"stability": \link{plotStability}}}
\item{\code{"pvals": \link{plotPvals}}} }

\code{"bootstrap"} and \code{"pvals"} only available for bootstrapped and
multi-sample split resampling. \code{"stability"} only available for
stability selection.
}
\examples{
\donttest{
fit1 <- resample(ggmDat, m = 'M', niter = 10)

net(fit1)
netInts(fit1)

plot(fit1)
plot(fit1, what = 'coefs')
plot(fit1, what = 'bootstrap', multi = TRUE)
plot(fit1, what = 'pvals', outcome = 2, predictor = 4)

fit2 <- resample(gvarDat, m = 'M', niter = 10, lags = 1, sampMethod = 'stability')

plot(fit2, what = 'stability', outcome = 3)
}
}
