% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_transform.R
\name{rbi_normal_transform}
\alias{rbi_normal_transform}
\title{Rank based inverse normal transformation}
\usage{
rbi_normal_transform(x, ties_method = c("max", "min", "average"))
}
\arguments{
\item{x}{a numeric vector}

\item{ties_method}{Method on how to deal with equal values 
during rank transformation.Acceptable input:"max","average","min". This
parameter is passed to the parameter \code{ties.method} of 
\code{\link[base]{rank}}.}
}
\value{
A numeric vector with rank transformed values.
}
\description{
Applies the rank based inverse normal transformation to numeric vector.
}
\details{
The rank based inverse normal transformation (Beasley et al. (2009)), 
transforms values of a vector to ranks and then applies the quantile 
function of the standard normal distribution.
}
\examples{

data("Cleveland",package="modgo")
test_rank <- rbi_normal_transform(Cleveland[,1])

}
\references{
Beasley, T.M. and Erickson S. and Allison D.B. (2009), 
``Rank-based inverse normal transformations are increasingly used, 
but are they merited?,'' \emph{Behavior genetics} \strong{39}, 580-595.
}
\author{
Andreas Ziegler, Francisco M. Ojeda, George Koliopanos
}
\keyword{Normal}
\keyword{rank}
\keyword{transformation}
