% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotel_rates.R
\name{data_hotel_rates}
\alias{data_hotel_rates}
\title{Daily Hotel Rate Data}
\source{
\url{https://github.com/rfordatascience/tidytuesday/tree/master/data/2020/2020-02-11}
}
\usage{
data_hotel_rates(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[pins:pin_read]{pins::pin_read()}}.}
}
\value{
A tibble.
}
\description{
A data set to predict the average daily rate for a hotel in Lisbon Portugal.
}
\details{
Data are originally described in Antonio, de Almeida, and Nunes (2019).
This version of the data is filtered for one hotel (the "Resort Hotel") and
is intended as regression data set for predicting the average daily rate for
a room. The data are post-2016; the 2016 data were used to have a predictor
for the historical daily rates. See the \code{hotel_rates.R} file in the
\code{data-raw} directory of the package to understand other filters used when
creating this version of the data.

The \code{agent} and \code{company} fields were changed from random characters to use
a set of random names.

The outcome column is \code{avg_price_per_room}.
\subsection{License}{

No license was given for the data; See the reference below for source.
}
}
\examples{
\donttest{
data_hotel_rates()
}
}
\references{
Antonio, N., de Almeida, A., and Nunes, L. (2019). Hotel booking demand
datasets. \emph{Data in Brief}, 22, 41-49.
}
