% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_C.R
\name{invChat}
\alias{invChat}
\title{Number of individuals corresponding to a desired coverage (inverse C_hat)}
\usage{
invChat(x, C)
}
\arguments{
\item{x}{integer vector (species abundances)}

\item{C}{coverage value between 0 and 1}
}
\value{
a numeric value which is the number of individuals for a given
level of coverage \code{C}.
}
\description{
If you wanted to resample a vector to a certain expected sample coverage, how
many individuals would you have to draw? This is C_hat solved for the number
of individuals. This code is a modification of INEXT's internal function
`invChat.Ind` (Hsieh et al 2016).
}
\examples{
data(inv_comm)
# What sample size corresponds to an expected sample coverage of 55\%?
invChat(colSums(inv_comm), 0.55)

}
\references{
Chao, A., and L. Jost. 2012. Coverage-based rarefaction and extrapolation:
 standardizing samples by completeness rather than size. Ecology 93:2533–2547.
 
Anne Chao, Nicholas J. Gotelli, T. C. Hsieh, Elizabeth L. Sander, K. H. Ma,
 Robert K. Colwell, and Aaron M. Ellison 2014. Rarefaction and extrapolation
 with Hill numbers: a framework for sampling and estimation in species
 diversity studies.  Ecological Monographs 84:45-67.

T. C. Hsieh, K. H. Ma and Anne Chao. 2024. 
 iNEXT: iNterpolation and EXTrapolation for
 species diversity. R package version 3.0.1
 URL: http://chao.stat.nthu.edu.tw/wordpress/software-download/.
}
\seealso{
\code{\link{calc_S_C}}
}
