% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerEReproAndGrowth}
\alias{mizerEReproAndGrowth}
\title{Get energy rate available for reproduction and growth  needed to project
standard mizer model}
\usage{
mizerEReproAndGrowth(
  params,
  n,
  n_pp,
  n_other,
  t,
  encounter,
  feeding_level,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{encounter}{An array (species x size) with the encounter rate as
calculated by \code{\link[=getEncounter]{getEncounter()}}.}

\item{feeding_level}{An array (species x size) with the feeding level as
calculated by \code{\link[=getFeedingLevel]{getFeedingLevel()}}.}

\item{...}{Unused}
}
\value{
A two dimensional array (species x size) holding
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, (1 - {\tt feeding\_level}_i(w))\,
                           {\tt encounter}_i(w) - {\tt metab}_i(w)).}{
  E_{r.i}(w) = max(0, alpha_i * (1 - feeding_level_i(w)) *
                      encounter_i(w) - metab_i(w)).}
Due to the form of the feeding level, calculated by
\code{\link[=getFeedingLevel]{getFeedingLevel()}}, if the feeding level is nonzero this can also be expressed as
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, {\tt feeding\_level}_i(w)\,
                           h_i(w) - {\tt metab}_i(w))}{
  E_{r.i}(w) = max(0, alpha_i * feeding_level_i(w) *
                      h_i(w) - metab_i(w))}
where \eqn{h_i} is the maximum intake rate, set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}. However this function is using the first equation
above so that it works also when the maximum intake rate is infinite, i.e.,
there is no satiation.
The assimilation rate \eqn{\alpha_i} is taken from the species parameter
data frame in \code{params}. The metabolic rate \code{metab} is taken from
\code{params} and set with \code{\link[=setMetabolicRate]{setMetabolicRate()}}.

The return value can be negative, which means that the energy intake does not
cover the cost of metabolism and movement.
}
\description{
Calculates the energy rate
\eqn{E_{r.i}(w)} (grams/year) available to an
individual of species i and size w for reproduction and growth after
metabolism and movement have been accounted for.
You would not usually call this function directly but instead use
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}, which then calls this function unless an alternative
function has been registered, see below.
}
\section{Your own energy rate function}{

By default \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}} calls \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}. However you
can replace this with your own alternative energy rate function. If
your function is called \code{"myEReproAndGrowth"} then you register it in a
MizerParams object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "EReproAndGrowth", "myEReproAndGrowth")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}, with
the same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
